"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExternalsListContents = ExternalsListContents;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _common = require("@kbn/kibana-react-plugin/common");
var _apm = require("../../../../../common/es_fields/apm");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ExternalResourcesList = _common.euiStyled.section`
  max-height: 360px;
  overflow: auto;
`;
function ExternalsListContents({
  elementData
}) {
  const nodeData = elementData;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(ExternalResourcesList, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, null, nodeData.groupedConnections.map(resource => {
    const title = resource.label || resource[_apm.SPAN_DESTINATION_SERVICE_RESOURCE];
    const desc = `${resource[_apm.SPAN_TYPE]} (${resource[_apm.SPAN_SUBTYPE]})`;
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      key: resource.id
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
      className: "eui-textTruncate",
      title: title
    }, title), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
      className: "eui-textTruncate",
      title: desc
    }, desc));
  }))));
}