"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GroupDetails = GroupDetails;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function GroupDetails({
  isEdit,
  serviceGroup,
  onCloseModal,
  onClickNext,
  onDeleteGroup,
  isLoading
}) {
  const [name, setName] = (0, _react.useState)((serviceGroup === null || serviceGroup === void 0 ? void 0 : serviceGroup.groupName) || '');
  const [color, setColor, colorPickerErrors] = (0, _eui.useColorPickerState)((serviceGroup === null || serviceGroup === void 0 ? void 0 : serviceGroup.color) || '#5094C4');
  const [description, setDescription] = (0, _react.useState)(serviceGroup === null || serviceGroup === void 0 ? void 0 : serviceGroup.description);
  (0, _react.useEffect)(() => {
    if (serviceGroup) {
      setName(serviceGroup.groupName);
      if (serviceGroup.color) {
        setColor(serviceGroup.color, {
          hex: serviceGroup.color,
          isValid: (0, _eui.isValidHex)(color)
        });
      }
      setDescription(serviceGroup.description);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [serviceGroup]); // setColor omitted: new reference each render

  const isInvalidColor = !!(colorPickerErrors !== null && colorPickerErrors !== void 0 && colorPickerErrors.length) || !(0, _eui.isValidHex)(color);
  const isInvalidName = !name;
  const isInvalid = isInvalidName || isInvalidColor;
  const inputRef = (0, _react.useRef)(null);
  (0, _react.useEffect)(() => {
    var _inputRef$current;
    (_inputRef$current = inputRef.current) === null || _inputRef$current === void 0 ? void 0 : _inputRef$current.focus(); // autofocus on initial render
  }, []);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, null, isEdit ? _i18n.i18n.translate('xpack.apm.serviceGroups.groupDetailsForm.edit.title', {
    defaultMessage: 'Edit group'
  }) : _i18n.i18n.translate('xpack.apm.serviceGroups.groupDetailsForm.create.title', {
    defaultMessage: 'Create group'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.apm.serviceGroups.groupDetailsForm.name', {
      defaultMessage: 'Name'
    }),
    isInvalid: isInvalidName
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    "data-test-subj": "apmGroupNameInput",
    value: name,
    onChange: e => {
      setName(e.target.value);
    },
    inputRef: inputRef
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.apm.serviceGroups.groupDetailsForm.color', {
      defaultMessage: 'Color'
    }),
    isInvalid: isInvalidColor,
    error: isInvalidColor ? _i18n.i18n.translate('xpack.apm.serviceGroups.groupDetailsForm.invalidColorError', {
      defaultMessage: 'Please provide a valid HEX color value'
    }) : undefined
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiColorPicker, {
    onChange: setColor,
    color: color,
    isInvalid: isInvalidColor
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.apm.serviceGroups.groupDetailsForm.description', {
      defaultMessage: 'Description'
    }),
    labelAppend: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      color: "subdued"
    }, _i18n.i18n.translate('xpack.apm.serviceGroups.groupDetailsForm.description.optional', {
      defaultMessage: 'Optional'
    }))
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    "data-test-subj": "apmGroupDetailsFieldText",
    fullWidth: true,
    value: description,
    onChange: e => {
      setDescription(e.target.value);
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, isEdit && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    iconType: "trash",
    iconSide: "left",
    onClick: () => {
      onDeleteGroup();
    },
    color: "danger",
    isDisabled: isLoading,
    "data-test-subj": "apmDeleteGroupButton"
  }, _i18n.i18n.translate('xpack.apm.serviceGroups.groupDetailsForm.deleteGroup', {
    defaultMessage: 'Delete group'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      marginLeft: 'auto'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "apmGroupDetailsCancelButton",
    onClick: onCloseModal,
    isDisabled: isLoading
  }, _i18n.i18n.translate('xpack.apm.serviceGroups.groupDetailsForm.cancel', {
    defaultMessage: 'Cancel'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "apmGroupDetailsSelectServicesButton",
    fill: true,
    iconType: "sortRight",
    iconSide: "right",
    onClick: () => {
      var _serviceGroup$kuery;
      onClickNext({
        groupName: name,
        color,
        description,
        kuery: (_serviceGroup$kuery = serviceGroup === null || serviceGroup === void 0 ? void 0 : serviceGroup.kuery) !== null && _serviceGroup$kuery !== void 0 ? _serviceGroup$kuery : ''
      });
    },
    isDisabled: isInvalid || isLoading
  }, _i18n.i18n.translate('xpack.apm.serviceGroups.groupDetailsForm.selectServices', {
    defaultMessage: 'Select services'
  }))))));
}