"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditButton = EditButton;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _service_groups_tour = require("../service_groups_tour");
var _use_service_groups_tour = require("../use_service_groups_tour");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function EditButton({
  onClick
}) {
  const {
    tourEnabled,
    dismissTour
  } = (0, _use_service_groups_tour.useServiceGroupsTour)('editGroup');
  return /*#__PURE__*/_react.default.createElement(_service_groups_tour.ServiceGroupsTour, {
    tourEnabled: tourEnabled,
    dismissTour: dismissTour,
    title: _i18n.i18n.translate('xpack.apm.serviceGroups.tour.editGroups.title', {
      defaultMessage: 'Edit this service group'
    }),
    content: _i18n.i18n.translate('xpack.apm.serviceGroups.tour.editGroups.content', {
      defaultMessage: 'Use the edit option to change the name, query, or details of this service group.'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "apmEditButtonEditGroupButton",
    iconType: "pencil",
    onClick: () => {
      dismissTour();
      onClick();
    }
  }, _i18n.i18n.translate('xpack.apm.serviceGroups.editGroupLabel', {
    defaultMessage: 'Edit group'
  })));
}