"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DashboardSelector = DashboardSelector;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _useMount = _interopRequireDefault(require("react-use/lib/useMount"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _url_helpers = require("../../shared/links/url_helpers");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function DashboardSelector({
  serviceDashboards,
  currentDashboardId,
  setCurrentDashboard
}) {
  const history = (0, _reactRouterDom.useHistory)();
  const [selectedDashboard, setSelectedDashboard] = (0, _react.useState)();
  (0, _useMount.default)(() => {
    if (!currentDashboardId) {
      history.push({
        ...history.location,
        search: (0, _url_helpers.fromQuery)({
          ...(0, _url_helpers.toQuery)(location.search),
          dashboardId: serviceDashboards[0].dashboardSavedObjectId
        })
      });
    }
  });
  (0, _react.useEffect)(() => {
    const preselectedDashboard = serviceDashboards.find(({
      dashboardSavedObjectId
    }) => dashboardSavedObjectId === currentDashboardId);
    // preselect dashboard
    if (preselectedDashboard) {
      setSelectedDashboard(preselectedDashboard);
      setCurrentDashboard(preselectedDashboard);
    }
  }, [serviceDashboards, currentDashboardId, setCurrentDashboard]);
  function onChange(newDashboardId) {
    history.push({
      ...history.location,
      search: (0, _url_helpers.fromQuery)({
        ...(0, _url_helpers.toQuery)(location.search),
        dashboardId: newDashboardId
      })
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    compressed: true,
    style: {
      minWidth: '200px'
    },
    placeholder: _i18n.i18n.translate('xpack.apm.serviceDashboards.selectDashboard.placeholder', {
      defaultMessage: 'Select dashboard'
    }),
    prepend: _i18n.i18n.translate('xpack.apm.serviceDashboards.selectDashboard.prepend', {
      defaultMessage: 'Dashboard'
    }),
    singleSelection: {
      asPlainText: true
    },
    options: serviceDashboards.map(({
      dashboardSavedObjectId,
      title
    }) => {
      return {
        label: title,
        value: dashboardSavedObjectId
      };
    }),
    selectedOptions: selectedDashboard ? [{
      value: selectedDashboard === null || selectedDashboard === void 0 ? void 0 : selectedDashboard.dashboardSavedObjectId,
      label: selectedDashboard === null || selectedDashboard === void 0 ? void 0 : selectedDashboard.title
    }] : [],
    onChange: ([newItem]) => onChange(newItem.value),
    isClearable: false
  });
}