"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.rackVariables = exports.rackLineNumbers = exports.rackHighlightLang = exports.rack = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const rackVariables = secretToken => ({
  ...(secretToken && {
    secretToken: 'secret_token'
  }),
  ...(!secretToken && {
    apiKey: 'api_key'
  }),
  apmServerUrl: 'server_url'
});
exports.rackVariables = rackVariables;
const rackHighlightLang = 'rb';
exports.rackHighlightLang = rackHighlightLang;
const rackLineNumbers = () => ({
  start: 1,
  highlight: '4, 7, 10, 13'
});
exports.rackLineNumbers = rackLineNumbers;
const rack = `# config/elastic_apm.yml:

# {{serviceNameHint}} ${_i18n.i18n.translate('xpack.apm.onboarding.rackClient.createConfig.commands.defaultsToTheNameOfRackAppClassComment', {
  defaultMessage: "Defaults to the name of your Rack app's class."
})}
service_name: '<your-service-name>'

{{^secretToken}}
# {{apiKeyHint}}
api_key: '{{{apiKey}}}'
{{/secretToken}}
{{#secretToken}}
# {{secretTokenHint}}
secret_token: '{{{secretToken}}}'
{{/secretToken}}

# {{{serverUrlHint}}}
server_url: '{{{apmServerUrl}}}'

# {{{serviceEnvironmentHint}}}
environment: '<your-environment>'`;
exports.rack = rack;