"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MobileTreemap = MobileTreemap;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _treemap_select = require("./treemap_select");
var _treemap_chart = require("../../../../shared/charts/treemap_chart");
var _use_fetcher = require("../../../../../hooks/use_fetcher");
var _apm = require("../../../../../../common/es_fields/apm");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ES_FIELD_MAPPING = {
  [_treemap_select.TreemapTypes.Devices]: _apm.DEVICE_MODEL_IDENTIFIER,
  [_treemap_select.TreemapTypes.Versions]: _apm.SERVICE_VERSION
};
function MobileTreemap({
  kuery,
  serviceName,
  start,
  end,
  environment
}) {
  var _data$terms;
  const [selectedTreemap, selectTreemap] = (0, _react.useState)(_treemap_select.TreemapTypes.Devices);
  const {
    data,
    status
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    const fieldName = ES_FIELD_MAPPING[selectedTreemap];
    if (fieldName) {
      return callApmApi('GET /internal/apm/mobile-services/{serviceName}/terms', {
        params: {
          path: {
            serviceName
          },
          query: {
            environment,
            kuery,
            start,
            end,
            fieldName,
            size: 500
          }
        }
      });
    }
  }, [environment, kuery, serviceName, start, end, selectedTreemap]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_treemap_select.TreemapSelect, {
    selectedTreemap: selectedTreemap,
    onChange: selectTreemap
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_treemap_chart.TreemapChart, {
    fetchStatus: status,
    data: (_data$terms = data === null || data === void 0 ? void 0 : data.terms) !== null && _data$terms !== void 0 ? _data$terms : [],
    id: "device-treemap",
    height: 320
  }));
}