"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ServerlessActiveInstances = ServerlessActiveInstances;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _formatters = require("../../../../../common/utils/formatters");
var _use_apm_service_context = require("../../../../context/apm_service/use_apm_service_context");
var _use_apm_params = require("../../../../hooks/use_apm_params");
var _use_fetcher = require("../../../../hooks/use_fetcher");
var _use_time_range = require("../../../../hooks/use_time_range");
var _timeseries_chart_with_context = require("../../../shared/charts/timeseries_chart_with_context");
var _list_metric = require("../../../shared/list_metric");
var _serverless_function_name_link = require("./serverless_function_name_link");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const palette = (0, _eui.euiPaletteColorBlind)({
  rotations: 2
});
function ServerlessActiveInstances({
  serverlessId
}) {
  const {
    query: {
      environment,
      kuery,
      rangeFrom,
      rangeTo
    }
  } = (0, _use_apm_params.useApmParams)('/services/{serviceName}/metrics');
  const {
    start,
    end
  } = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo
  });
  const {
    serviceName
  } = (0, _use_apm_service_context.useApmServiceContext)();
  const {
    data = {
      activeInstances: [],
      timeseries: []
    },
    status
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    if (!start || !end) {
      return undefined;
    }
    return callApmApi('GET /internal/apm/services/{serviceName}/metrics/serverless/active_instances', {
      params: {
        path: {
          serviceName
        },
        query: {
          kuery,
          environment,
          start,
          end,
          serverlessId
        }
      }
    });
  }, [kuery, environment, serviceName, start, end, serverlessId]);
  const isLoading = status === _use_fetcher.FETCH_STATUS.LOADING;
  const columns = [{
    field: 'serverlessFunctionName',
    name: _i18n.i18n.translate('xpack.apm.serverlessMetrics.activeInstances.functionName', {
      defaultMessage: 'Function name'
    }),
    sortable: true,
    truncateText: true,
    render: (_, item) => {
      return /*#__PURE__*/_react.default.createElement(_serverless_function_name_link.ServerlessFunctionNameLink, {
        serverlessFunctionName: item.serverlessFunctionName,
        serverlessId: item.serverlessId
      });
    }
  }, {
    field: 'activeInstanceName',
    name: _i18n.i18n.translate('xpack.apm.serverlessMetrics.activeInstances.name', {
      defaultMessage: 'Name'
    }),
    sortable: true
  }, {
    field: 'serverlessDurationAvg',
    name: _i18n.i18n.translate('xpack.apm.serverlessMetrics.serverlessFunctions.functionDuration', {
      defaultMessage: 'Function duration'
    }),
    sortable: true,
    render: (_, {
      serverlessDurationAvg,
      timeseries
    }) => {
      return /*#__PURE__*/_react.default.createElement(_list_metric.ListMetric, {
        isLoading: isLoading,
        series: timeseries.serverlessDuration,
        color: palette[1],
        valueLabel: (0, _formatters.asMillisecondDuration)(serverlessDurationAvg)
      });
    }
  }, {
    field: 'billedDurationAvg',
    name: _i18n.i18n.translate('xpack.apm.serverlessMetrics.activeInstances.billedDuration', {
      defaultMessage: 'Billed duration'
    }),
    sortable: true,
    render: (_, {
      billedDurationAvg,
      timeseries
    }) => {
      return /*#__PURE__*/_react.default.createElement(_list_metric.ListMetric, {
        isLoading: isLoading,
        series: timeseries.billedDuration,
        color: palette[2],
        valueLabel: (0, _formatters.asMillisecondDuration)(billedDurationAvg)
      });
    }
  }, {
    field: 'avgMemoryUsed',
    name: _i18n.i18n.translate('xpack.apm.serverlessMetrics.activeInstances.memoryUsageAvg', {
      defaultMessage: 'Memory usage avg.'
    }),
    sortable: true,
    render: (_, {
      avgMemoryUsed
    }) => {
      return (0, _formatters.asDynamicBytes)(avgMemoryUsed);
    }
  }, {
    field: 'memorySize',
    name: _i18n.i18n.translate('xpack.apm.serverlessMetrics.activeInstances.memorySize', {
      defaultMessage: 'Memory size'
    }),
    sortable: true,
    render: (_, {
      memorySize
    }) => {
      return (0, _formatters.asDynamicBytes)(memorySize);
    }
  }];
  const sorting = (0, _react.useMemo)(() => ({
    sort: {
      field: 'serverlessDurationAvg',
      direction: 'desc'
    }
  }), []);
  const charts = (0, _react.useMemo)(() => [{
    title: _i18n.i18n.translate('xpack.apm.serverlessMetrics.activeInstances.title', {
      defaultMessage: 'Active instances'
    }),
    data: data.timeseries,
    type: 'bar',
    color: palette[2]
  }], [data.timeseries]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.apm.serverlessMetrics.activeInstances.title', {
    defaultMessage: 'Active instances'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_timeseries_chart_with_context.TimeseriesChartWithContext, {
    timeseries: charts,
    id: "activeInstances",
    fetchStatus: status,
    yLabelFormat: _formatters.asInteger
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    loading: isLoading,
    items: data.activeInstances,
    columns: columns,
    pagination: {
      showPerPageOptions: false,
      pageSize: 5
    },
    sorting: sorting
  }))));
}