"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ApmFeatureFlagName = void 0;
exports.getApmFeatureFlags = getApmFeatureFlags;
var t = _interopRequireWildcard(require("io-ts"));
var _lodash = require("lodash");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let ApmFeatureFlagName;
exports.ApmFeatureFlagName = ApmFeatureFlagName;
(function (ApmFeatureFlagName) {
  ApmFeatureFlagName["AgentConfigurationAvailable"] = "agentConfigurationAvailable";
  ApmFeatureFlagName["ConfigurableIndicesAvailable"] = "configurableIndicesAvailable";
  ApmFeatureFlagName["InfrastructureTabAvailable"] = "infrastructureTabAvailable";
  ApmFeatureFlagName["InfraUiAvailable"] = "infraUiAvailable";
  ApmFeatureFlagName["MigrationToFleetAvailable"] = "migrationToFleetAvailable";
  ApmFeatureFlagName["SourcemapApiAvailable"] = "sourcemapApiAvailable";
  ApmFeatureFlagName["StorageExplorerAvailable"] = "storageExplorerAvailable";
  ApmFeatureFlagName["ProfilingIntegrationAvailable"] = "profilingIntegrationAvailable";
})(ApmFeatureFlagName || (exports.ApmFeatureFlagName = ApmFeatureFlagName = {}));
const apmFeatureFlagMap = {
  [ApmFeatureFlagName.AgentConfigurationAvailable]: {
    default: true,
    type: t.boolean
  },
  [ApmFeatureFlagName.ConfigurableIndicesAvailable]: {
    default: true,
    type: t.boolean
  },
  [ApmFeatureFlagName.InfrastructureTabAvailable]: {
    default: true,
    type: t.boolean
  },
  [ApmFeatureFlagName.InfraUiAvailable]: {
    default: true,
    type: t.boolean
  },
  [ApmFeatureFlagName.MigrationToFleetAvailable]: {
    default: true,
    type: t.boolean
  },
  [ApmFeatureFlagName.SourcemapApiAvailable]: {
    default: true,
    type: t.boolean
  },
  [ApmFeatureFlagName.StorageExplorerAvailable]: {
    default: true,
    type: t.boolean
  },
  [ApmFeatureFlagName.ProfilingIntegrationAvailable]: {
    default: false,
    type: t.boolean
  }
};
function getApmFeatureFlags() {
  return (0, _lodash.mapValues)(apmFeatureFlagMap, (value, key) => value.default);
}