"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ApmDataAccessPlugin = void 0;
var _migrate_legacy_apm_indices_to_space_aware = require("./saved_objects/migrations/migrate_legacy_apm_indices_to_space_aware");
var _apm_indices = require("./saved_objects/apm_indices");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class ApmDataAccessPlugin {
  constructor(initContext) {
    this.initContext = initContext;
    this.initContext = initContext;
  }
  setup(core) {
    // retrieve APM indices from config
    const apmDataAccessConfig = this.initContext.config.get();
    const apmIndicesFromConfigFile = apmDataAccessConfig.indices;

    // register saved object
    core.savedObjects.registerType(_apm_indices.apmIndicesSavedObjectDefinition);

    // expose
    return {
      apmIndicesFromConfigFile,
      getApmIndices: async savedObjectsClient => {
        const apmIndicesFromSavedObject = await (0, _apm_indices.getApmIndicesSavedObject)(savedObjectsClient);
        return {
          ...apmIndicesFromConfigFile,
          ...apmIndicesFromSavedObject
        };
      }
    };
  }
  start(core) {
    const logger = this.initContext.logger.get();
    // TODO: remove in 9.0
    (0, _migrate_legacy_apm_indices_to_space_aware.migrateLegacyAPMIndicesToSpaceAware)({
      coreStart: core,
      logger
    }).catch(e => {
      logger.error('Failed to run migration making APM indices space aware');
      logger.error(e);
    });
    return {};
  }
  stop() {}
}
exports.ApmDataAccessPlugin = ApmDataAccessPlugin;