"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ErrorWithCode = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Custom error to report the error message with an additional error code.
 */
class ErrorWithCode extends Error {
  /**
   * Constructor of the error.
   * @param message The error message.
   * @param code The code of the error.
   */
  constructor(message, code) {
    super(message);
    this.code = code;
  }
}
exports.ErrorWithCode = ErrorWithCode;