"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.schemaUnknownArray = exports.schemaUnknown = exports.schemaStringOrNumberArray = exports.schemaStringOrNumber = exports.schemaStringArray = exports.schemaString = exports.schemaNumberArray = exports.schemaNumber = exports.schemaGeoPointArray = exports.schemaGeoPoint = exports.schemaDateRangeArray = exports.schemaDateRange = exports.schemaDateArray = exports.schemaDate = exports.schemaBooleanArray = exports.schemaBoolean = exports.LegacyAlertSchema = exports.IsoDateString = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
// ---------------------------------- WARNING ----------------------------------
// this file was generated, and should not be edited by hand
// ---------------------------------- WARNING ----------------------------------

const ISO_DATE_PATTERN = /^d{4}-d{2}-d{2}Td{2}:d{2}:d{2}.d{3}Z$/;
const IsoDateString = new rt.Type('IsoDateString', rt.string.is, (input, context) => {
  if (typeof input === 'string' && ISO_DATE_PATTERN.test(input)) {
    return rt.success(input);
  } else {
    return rt.failure(input, context);
  }
}, rt.identity);
exports.IsoDateString = IsoDateString;
const schemaUnknown = rt.unknown;
exports.schemaUnknown = schemaUnknown;
const schemaUnknownArray = rt.array(rt.unknown);
exports.schemaUnknownArray = schemaUnknownArray;
const schemaString = rt.string;
exports.schemaString = schemaString;
const schemaStringArray = rt.array(schemaString);
exports.schemaStringArray = schemaStringArray;
const schemaNumber = rt.number;
exports.schemaNumber = schemaNumber;
const schemaNumberArray = rt.array(schemaNumber);
exports.schemaNumberArray = schemaNumberArray;
const schemaDate = rt.union([IsoDateString, schemaNumber]);
exports.schemaDate = schemaDate;
const schemaDateArray = rt.array(schemaDate);
exports.schemaDateArray = schemaDateArray;
const schemaDateRange = rt.partial({
  gte: schemaDate,
  lte: schemaDate
});
exports.schemaDateRange = schemaDateRange;
const schemaDateRangeArray = rt.array(schemaDateRange);
exports.schemaDateRangeArray = schemaDateRangeArray;
const schemaStringOrNumber = rt.union([schemaString, schemaNumber]);
exports.schemaStringOrNumber = schemaStringOrNumber;
const schemaStringOrNumberArray = rt.array(schemaStringOrNumber);
exports.schemaStringOrNumberArray = schemaStringOrNumberArray;
const schemaBoolean = rt.boolean;
exports.schemaBoolean = schemaBoolean;
const schemaBooleanArray = rt.array(schemaBoolean);
exports.schemaBooleanArray = schemaBooleanArray;
const schemaGeoPointCoords = rt.type({
  type: schemaString,
  coordinates: schemaNumberArray
});
const schemaGeoPointString = schemaString;
const schemaGeoPointLatLon = rt.type({
  lat: schemaNumber,
  lon: schemaNumber
});
const schemaGeoPointLocation = rt.type({
  location: schemaNumberArray
});
const schemaGeoPointLocationString = rt.type({
  location: schemaString
});
const schemaGeoPoint = rt.union([schemaGeoPointCoords, schemaGeoPointString, schemaGeoPointLatLon, schemaGeoPointLocation, schemaGeoPointLocationString]);
exports.schemaGeoPoint = schemaGeoPoint;
const schemaGeoPointArray = rt.array(schemaGeoPoint);
// prettier-ignore
exports.schemaGeoPointArray = schemaGeoPointArray;
const LegacyAlertRequired = rt.type({});
const LegacyAlertOptional = rt.partial({
  'ecs.version': schemaString,
  'kibana.alert.risk_score': schemaNumber,
  'kibana.alert.rule.author': schemaString,
  'kibana.alert.rule.created_at': schemaDate,
  'kibana.alert.rule.created_by': schemaString,
  'kibana.alert.rule.description': schemaString,
  'kibana.alert.rule.enabled': schemaString,
  'kibana.alert.rule.from': schemaString,
  'kibana.alert.rule.interval': schemaString,
  'kibana.alert.rule.license': schemaString,
  'kibana.alert.rule.note': schemaString,
  'kibana.alert.rule.references': schemaStringArray,
  'kibana.alert.rule.rule_id': schemaString,
  'kibana.alert.rule.rule_name_override': schemaString,
  'kibana.alert.rule.to': schemaString,
  'kibana.alert.rule.type': schemaString,
  'kibana.alert.rule.updated_at': schemaDate,
  'kibana.alert.rule.updated_by': schemaString,
  'kibana.alert.rule.version': schemaString,
  'kibana.alert.severity': schemaString,
  'kibana.alert.suppression.docs_count': schemaStringOrNumber,
  'kibana.alert.suppression.end': schemaDate,
  'kibana.alert.suppression.start': schemaDate,
  'kibana.alert.suppression.terms.field': schemaStringArray,
  'kibana.alert.suppression.terms.value': schemaStringArray,
  'kibana.alert.system_status': schemaString,
  'kibana.alert.workflow_reason': schemaString,
  'kibana.alert.workflow_status_updated_at': schemaDate,
  'kibana.alert.workflow_user': schemaString
});

// prettier-ignore
const LegacyAlertSchema = rt.intersection([LegacyAlertRequired, LegacyAlertOptional]);
// prettier-ignore
exports.LegacyAlertSchema = LegacyAlertSchema;