"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.schemaUnknownArray = exports.schemaUnknown = exports.schemaStringOrNumberArray = exports.schemaStringOrNumber = exports.schemaStringArray = exports.schemaString = exports.schemaNumberArray = exports.schemaNumber = exports.schemaGeoPointArray = exports.schemaGeoPoint = exports.schemaDateRangeArray = exports.schemaDateRange = exports.schemaDateArray = exports.schemaDate = exports.schemaBooleanArray = exports.schemaBoolean = exports.IsoDateString = exports.AlertSchema = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
// ---------------------------------- WARNING ----------------------------------
// this file was generated, and should not be edited by hand
// ---------------------------------- WARNING ----------------------------------

const ISO_DATE_PATTERN = /^d{4}-d{2}-d{2}Td{2}:d{2}:d{2}.d{3}Z$/;
const IsoDateString = new rt.Type('IsoDateString', rt.string.is, (input, context) => {
  if (typeof input === 'string' && ISO_DATE_PATTERN.test(input)) {
    return rt.success(input);
  } else {
    return rt.failure(input, context);
  }
}, rt.identity);
exports.IsoDateString = IsoDateString;
const schemaUnknown = rt.unknown;
exports.schemaUnknown = schemaUnknown;
const schemaUnknownArray = rt.array(rt.unknown);
exports.schemaUnknownArray = schemaUnknownArray;
const schemaString = rt.string;
exports.schemaString = schemaString;
const schemaStringArray = rt.array(schemaString);
exports.schemaStringArray = schemaStringArray;
const schemaNumber = rt.number;
exports.schemaNumber = schemaNumber;
const schemaNumberArray = rt.array(schemaNumber);
exports.schemaNumberArray = schemaNumberArray;
const schemaDate = rt.union([IsoDateString, schemaNumber]);
exports.schemaDate = schemaDate;
const schemaDateArray = rt.array(schemaDate);
exports.schemaDateArray = schemaDateArray;
const schemaDateRange = rt.partial({
  gte: schemaDate,
  lte: schemaDate
});
exports.schemaDateRange = schemaDateRange;
const schemaDateRangeArray = rt.array(schemaDateRange);
exports.schemaDateRangeArray = schemaDateRangeArray;
const schemaStringOrNumber = rt.union([schemaString, schemaNumber]);
exports.schemaStringOrNumber = schemaStringOrNumber;
const schemaStringOrNumberArray = rt.array(schemaStringOrNumber);
exports.schemaStringOrNumberArray = schemaStringOrNumberArray;
const schemaBoolean = rt.boolean;
exports.schemaBoolean = schemaBoolean;
const schemaBooleanArray = rt.array(schemaBoolean);
exports.schemaBooleanArray = schemaBooleanArray;
const schemaGeoPointCoords = rt.type({
  type: schemaString,
  coordinates: schemaNumberArray
});
const schemaGeoPointString = schemaString;
const schemaGeoPointLatLon = rt.type({
  lat: schemaNumber,
  lon: schemaNumber
});
const schemaGeoPointLocation = rt.type({
  location: schemaNumberArray
});
const schemaGeoPointLocationString = rt.type({
  location: schemaString
});
const schemaGeoPoint = rt.union([schemaGeoPointCoords, schemaGeoPointString, schemaGeoPointLatLon, schemaGeoPointLocation, schemaGeoPointLocationString]);
exports.schemaGeoPoint = schemaGeoPoint;
const schemaGeoPointArray = rt.array(schemaGeoPoint);
// prettier-ignore
exports.schemaGeoPointArray = schemaGeoPointArray;
const AlertRequired = rt.type({
  '@timestamp': schemaDate,
  'kibana.alert.instance.id': schemaString,
  'kibana.alert.rule.category': schemaString,
  'kibana.alert.rule.consumer': schemaString,
  'kibana.alert.rule.name': schemaString,
  'kibana.alert.rule.producer': schemaString,
  'kibana.alert.rule.revision': schemaStringOrNumber,
  'kibana.alert.rule.rule_type_id': schemaString,
  'kibana.alert.rule.uuid': schemaString,
  'kibana.alert.status': schemaString,
  'kibana.alert.uuid': schemaString,
  'kibana.space_ids': schemaStringArray
});
const AlertOptional = rt.partial({
  'event.action': schemaString,
  'event.kind': schemaString,
  'kibana.alert.action_group': schemaString,
  'kibana.alert.case_ids': schemaStringArray,
  'kibana.alert.duration.us': schemaStringOrNumber,
  'kibana.alert.end': schemaDate,
  'kibana.alert.flapping': schemaBoolean,
  'kibana.alert.flapping_history': schemaBooleanArray,
  'kibana.alert.last_detected': schemaDate,
  'kibana.alert.maintenance_window_ids': schemaStringArray,
  'kibana.alert.reason': schemaString,
  'kibana.alert.rule.execution.uuid': schemaString,
  'kibana.alert.rule.parameters': schemaUnknown,
  'kibana.alert.rule.tags': schemaStringArray,
  'kibana.alert.start': schemaDate,
  'kibana.alert.time_range': schemaDateRange,
  'kibana.alert.url': schemaString,
  'kibana.alert.workflow_assignee_ids': schemaStringArray,
  'kibana.alert.workflow_status': schemaString,
  'kibana.alert.workflow_tags': schemaStringArray,
  'kibana.version': schemaString,
  tags: schemaStringArray
});

// prettier-ignore
const AlertSchema = rt.intersection([AlertRequired, AlertOptional]);
// prettier-ignore
exports.AlertSchema = AlertSchema;