"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.rawRuleSchema = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const executionStatusWarningReason = _configSchema.schema.oneOf([_configSchema.schema.literal('maxExecutableActions'), _configSchema.schema.literal('maxAlerts'), _configSchema.schema.literal('maxQueuedActions')]);
const executionStatusErrorReason = _configSchema.schema.oneOf([_configSchema.schema.literal('read'), _configSchema.schema.literal('decrypt'), _configSchema.schema.literal('execute'), _configSchema.schema.literal('unknown'), _configSchema.schema.literal('license'), _configSchema.schema.literal('timeout'), _configSchema.schema.literal('disabled'), _configSchema.schema.literal('validate')]);
const rawRuleExecutionStatusSchema = _configSchema.schema.object({
  status: _configSchema.schema.oneOf([_configSchema.schema.literal('ok'), _configSchema.schema.literal('active'), _configSchema.schema.literal('error'), _configSchema.schema.literal('pending'), _configSchema.schema.literal('unknown'), _configSchema.schema.literal('warning')]),
  lastExecutionDate: _configSchema.schema.string(),
  lastDuration: _configSchema.schema.maybe(_configSchema.schema.number()),
  error: _configSchema.schema.nullable(_configSchema.schema.object({
    reason: executionStatusErrorReason,
    message: _configSchema.schema.string()
  })),
  warning: _configSchema.schema.nullable(_configSchema.schema.object({
    reason: executionStatusWarningReason,
    message: _configSchema.schema.string()
  }))
});
const ISOWeekdaysSchema = _configSchema.schema.oneOf([_configSchema.schema.literal(1), _configSchema.schema.literal(2), _configSchema.schema.literal(3), _configSchema.schema.literal(4), _configSchema.schema.literal(5), _configSchema.schema.literal(6), _configSchema.schema.literal(7)]);
const rRuleSchema = _configSchema.schema.object({
  dtstart: _configSchema.schema.string(),
  tzid: _configSchema.schema.string(),
  freq: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal(0), _configSchema.schema.literal(1), _configSchema.schema.literal(2), _configSchema.schema.literal(3), _configSchema.schema.literal(4), _configSchema.schema.literal(5), _configSchema.schema.literal(6)])),
  until: _configSchema.schema.maybe(_configSchema.schema.string()),
  count: _configSchema.schema.maybe(_configSchema.schema.number()),
  interval: _configSchema.schema.maybe(_configSchema.schema.number()),
  wkst: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal('MO'), _configSchema.schema.literal('TU'), _configSchema.schema.literal('WE'), _configSchema.schema.literal('TH'), _configSchema.schema.literal('FR'), _configSchema.schema.literal('SA'), _configSchema.schema.literal('SU')])),
  byweekday: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.oneOf([_configSchema.schema.string(), _configSchema.schema.number()]))),
  bymonth: _configSchema.schema.maybe(_configSchema.schema.number()),
  bysetpos: _configSchema.schema.maybe(_configSchema.schema.number()),
  bymonthday: _configSchema.schema.maybe(_configSchema.schema.number()),
  byyearday: _configSchema.schema.maybe(_configSchema.schema.number()),
  byweekno: _configSchema.schema.maybe(_configSchema.schema.number()),
  byhour: _configSchema.schema.maybe(_configSchema.schema.number()),
  byminute: _configSchema.schema.maybe(_configSchema.schema.number()),
  bysecond: _configSchema.schema.maybe(_configSchema.schema.number())
});
const outcome = _configSchema.schema.oneOf([_configSchema.schema.literal('succeeded'), _configSchema.schema.literal('warning'), _configSchema.schema.literal('failed')]);
const rawRuleLastRunSchema = _configSchema.schema.object({
  outcome,
  outcomeOrder: _configSchema.schema.maybe(_configSchema.schema.number()),
  alertsCount: _configSchema.schema.object({
    new: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.number())),
    active: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.number())),
    recovered: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.number())),
    ignored: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.number()))
  }),
  outcomeMsg: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.arrayOf(_configSchema.schema.string()))),
  warning: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.oneOf([executionStatusErrorReason, executionStatusWarningReason])))
});
const rawRuleMonitoringSchema = _configSchema.schema.object({
  run: _configSchema.schema.object({
    history: _configSchema.schema.arrayOf(_configSchema.schema.object({
      success: _configSchema.schema.boolean(),
      timestamp: _configSchema.schema.number(),
      duration: _configSchema.schema.maybe(_configSchema.schema.number()),
      outcome: _configSchema.schema.maybe(outcome)
    })),
    calculated_metrics: _configSchema.schema.object({
      p50: _configSchema.schema.maybe(_configSchema.schema.number()),
      p95: _configSchema.schema.maybe(_configSchema.schema.number()),
      p99: _configSchema.schema.maybe(_configSchema.schema.number()),
      success_ratio: _configSchema.schema.number()
    }),
    last_run: _configSchema.schema.object({
      timestamp: _configSchema.schema.string(),
      metrics: _configSchema.schema.object({
        duration: _configSchema.schema.maybe(_configSchema.schema.number()),
        total_search_duration_ms: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.number())),
        total_indexing_duration_ms: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.number())),
        total_alerts_detected: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.number())),
        total_alerts_created: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.number())),
        gap_duration_s: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.number()))
      })
    })
  })
});
const rawRuleAlertsFilterSchema = _configSchema.schema.object({
  query: _configSchema.schema.maybe(_configSchema.schema.object({
    kql: _configSchema.schema.string(),
    filters: _configSchema.schema.arrayOf(_configSchema.schema.object({
      query: _configSchema.schema.maybe(_configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.any())),
      meta: _configSchema.schema.object({
        alias: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.string())),
        disabled: _configSchema.schema.maybe(_configSchema.schema.boolean()),
        negate: _configSchema.schema.maybe(_configSchema.schema.boolean()),
        controlledBy: _configSchema.schema.maybe(_configSchema.schema.string()),
        group: _configSchema.schema.maybe(_configSchema.schema.string()),
        index: _configSchema.schema.maybe(_configSchema.schema.string()),
        isMultiIndex: _configSchema.schema.maybe(_configSchema.schema.boolean()),
        type: _configSchema.schema.maybe(_configSchema.schema.string()),
        key: _configSchema.schema.maybe(_configSchema.schema.string()),
        params: _configSchema.schema.maybe(_configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.any())),
        // better type?
        value: _configSchema.schema.maybe(_configSchema.schema.string()),
        field: _configSchema.schema.maybe(_configSchema.schema.string())
      }),
      $state: _configSchema.schema.maybe(_configSchema.schema.object({
        store: _configSchema.schema.oneOf([_configSchema.schema.literal('appState'), _configSchema.schema.literal('globalState')])
      }))
    })),
    dsl: _configSchema.schema.maybe(_configSchema.schema.string())
  })),
  timeframe: _configSchema.schema.maybe(_configSchema.schema.object({
    days: _configSchema.schema.arrayOf(ISOWeekdaysSchema),
    hours: _configSchema.schema.object({
      start: _configSchema.schema.string(),
      end: _configSchema.schema.string()
    }),
    timezone: _configSchema.schema.string()
  }))
});
const rawRuleActionSchema = _configSchema.schema.object({
  uuid: _configSchema.schema.maybe(_configSchema.schema.string()),
  group: _configSchema.schema.string(),
  actionRef: _configSchema.schema.string(),
  actionTypeId: _configSchema.schema.string(),
  params: _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.any()),
  frequency: _configSchema.schema.maybe(_configSchema.schema.object({
    summary: _configSchema.schema.boolean(),
    notifyWhen: _configSchema.schema.oneOf([_configSchema.schema.literal('onActionGroupChange'), _configSchema.schema.literal('onActiveAlert'), _configSchema.schema.literal('onThrottleInterval')]),
    throttle: _configSchema.schema.nullable(_configSchema.schema.string())
  })),
  alertsFilter: _configSchema.schema.maybe(rawRuleAlertsFilterSchema),
  useAlertDataForTemplate: _configSchema.schema.maybe(_configSchema.schema.boolean())
});
const rawRuleSchema = _configSchema.schema.object({
  name: _configSchema.schema.string(),
  enabled: _configSchema.schema.boolean(),
  consumer: _configSchema.schema.string(),
  tags: _configSchema.schema.arrayOf(_configSchema.schema.string()),
  alertTypeId: _configSchema.schema.string(),
  apiKeyOwner: _configSchema.schema.nullable(_configSchema.schema.string()),
  apiKey: _configSchema.schema.nullable(_configSchema.schema.string()),
  apiKeyCreatedByUser: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.boolean())),
  createdBy: _configSchema.schema.nullable(_configSchema.schema.string()),
  updatedBy: _configSchema.schema.nullable(_configSchema.schema.string()),
  updatedAt: _configSchema.schema.string(),
  createdAt: _configSchema.schema.string(),
  muteAll: _configSchema.schema.boolean(),
  mutedInstanceIds: _configSchema.schema.arrayOf(_configSchema.schema.string()),
  throttle: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.string())),
  revision: _configSchema.schema.number(),
  running: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.boolean())),
  schedule: _configSchema.schema.object({
    interval: _configSchema.schema.string()
  }),
  legacyId: _configSchema.schema.nullable(_configSchema.schema.string()),
  scheduledTaskId: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.string())),
  isSnoozedUntil: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.string())),
  snoozeSchedule: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.object({
    duration: _configSchema.schema.number(),
    rRule: rRuleSchema,
    id: _configSchema.schema.maybe(_configSchema.schema.string()),
    skipRecurrences: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string()))
  }))),
  meta: _configSchema.schema.maybe(_configSchema.schema.object({
    versionApiKeyLastmodified: _configSchema.schema.maybe(_configSchema.schema.string())
  })),
  actions: _configSchema.schema.arrayOf(rawRuleActionSchema),
  executionStatus: rawRuleExecutionStatusSchema,
  notifyWhen: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.oneOf([_configSchema.schema.literal('onActionGroupChange'), _configSchema.schema.literal('onActiveAlert'), _configSchema.schema.literal('onThrottleInterval')]))),
  monitoring: _configSchema.schema.maybe(rawRuleMonitoringSchema),
  lastRun: _configSchema.schema.maybe(_configSchema.schema.nullable(rawRuleLastRunSchema)),
  nextRun: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.string())),
  mapped_params: _configSchema.schema.maybe(_configSchema.schema.object({
    risk_score: _configSchema.schema.maybe(_configSchema.schema.number()),
    severity: _configSchema.schema.maybe(_configSchema.schema.string())
  })),
  params: _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.maybe(_configSchema.schema.any())),
  typeVersion: _configSchema.schema.maybe(_configSchema.schema.number())
});
exports.rawRuleSchema = rawRuleSchema;