"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.rewriteActionsRes = exports.rewriteActionsReq = void 0;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const rewriteActionsReq = actions => {
  if (!actions) return [];
  return actions.map(({
    frequency,
    alerts_filter: alertsFilter,
    use_alert_data_for_template: useAlertDataForTemplate,
    ...action
  }) => {
    return {
      ...action,
      ...(typeof useAlertDataForTemplate !== 'undefined' ? {
        useAlertDataForTemplate
      } : {}),
      ...(frequency ? {
        frequency: {
          ...(0, _lodash.omit)(frequency, 'notify_when'),
          notifyWhen: frequency.notify_when
        }
      } : {}),
      ...(alertsFilter ? {
        alertsFilter
      } : {})
    };
  });
};
exports.rewriteActionsReq = rewriteActionsReq;
const rewriteActionsRes = actions => {
  const rewriteFrequency = ({
    notifyWhen,
    ...rest
  }) => ({
    ...rest,
    notify_when: notifyWhen
  });
  if (!actions) return [];
  return actions.map(({
    actionTypeId,
    frequency,
    alertsFilter,
    useAlertDataForTemplate,
    ...action
  }) => ({
    ...action,
    connector_type_id: actionTypeId,
    ...(typeof useAlertDataForTemplate !== 'undefined' ? {
      use_alert_data_for_template: useAlertDataForTemplate
    } : {}),
    ...(frequency ? {
      frequency: rewriteFrequency(frequency)
    } : {}),
    ...(alertsFilter ? {
      alerts_filter: alertsFilter
    } : {})
  }));
};
exports.rewriteActionsRes = rewriteActionsRes;