"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAlertsForNotification = getAlertsForNotification;
var _lodash = require("lodash");
var _alert = require("../alert");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getAlertsForNotification(flappingSettings, notifyOnActionGroupChange, actionGroupId, newAlerts = {}, activeAlerts = {}, recoveredAlerts = {}, currentRecoveredAlerts = {}) {
  const currentActiveAlerts = {};
  for (const id of (0, _lodash.keys)(activeAlerts)) {
    const alert = activeAlerts[id];
    alert.resetPendingRecoveredCount();
    currentActiveAlerts[id] = alert;
  }
  for (const id of (0, _lodash.keys)(currentRecoveredAlerts)) {
    const alert = recoveredAlerts[id];
    if (flappingSettings.enabled) {
      const flapping = alert.getFlapping();
      if (flapping) {
        alert.incrementPendingRecoveredCount();
        if (alert.getPendingRecoveredCount() < flappingSettings.statusChangeThreshold) {
          var _alert$getLastSchedul;
          // keep the context and previous actionGroupId if available
          const context = alert.getContext();
          const lastActionGroupId = (_alert$getLastSchedul = alert.getLastScheduledActions()) === null || _alert$getLastSchedul === void 0 ? void 0 : _alert$getLastSchedul.group;
          const newAlert = new _alert.Alert(id, alert.toRaw());
          // unset the end time in the alert state
          const state = newAlert.getState();
          delete state.end;
          newAlert.replaceState(state);

          // schedule actions for the new active alert
          newAlert.scheduleActions(lastActionGroupId ? lastActionGroupId : actionGroupId, context);
          activeAlerts[id] = newAlert;

          // rule with "on status change" or rule with at least one
          // action with "on status change" should return notifications
          if (notifyOnActionGroupChange) {
            currentActiveAlerts[id] = newAlert;
          }

          // remove from recovered alerts
          delete recoveredAlerts[id];
          delete currentRecoveredAlerts[id];
        } else {
          alert.resetPendingRecoveredCount();
        }
      }
    } else {
      alert.resetPendingRecoveredCount();
    }
  }
  return {
    newAlerts,
    activeAlerts,
    currentActiveAlerts,
    recoveredAlerts,
    currentRecoveredAlerts
  };
}