"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.bulkGetMaintenanceWindowSo = void 0;
var _common = require("../../../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const bulkGetMaintenanceWindowSo = params => {
  const {
    objects,
    savedObjectsClient
  } = params;
  return savedObjectsClient.bulkGet(objects.map(object => ({
    id: object.id,
    type: _common.MAINTENANCE_WINDOW_SAVED_OBJECT_TYPE
  })));
};
exports.bulkGetMaintenanceWindowSo = bulkGetMaintenanceWindowSo;