"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.findMaintenanceWindows = findMaintenanceWindows;
var _common = require("../../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const rewriteBodyRes = results => {
  return results.data.map(item => transform(item));
};
const transform = ({
  expiration_date: expirationDate,
  r_rule: rRule,
  event_start_time: eventStartTime,
  event_end_time: eventEndTime,
  created_by: createdBy,
  updated_by: updatedBy,
  created_at: createdAt,
  updated_at: updatedAt,
  ...rest
}) => ({
  ...rest,
  expirationDate,
  rRule,
  eventStartTime,
  eventEndTime,
  createdBy,
  updatedBy,
  createdAt,
  updatedAt
});
async function findMaintenanceWindows({
  http
}) {
  const res = await http.get(`${_common.INTERNAL_BASE_ALERTING_API_PATH}/rules/maintenance_window/_find`);
  return rewriteBodyRes(res);
}