"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.archiveMaintenanceWindow = archiveMaintenanceWindow;
var _common = require("../../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const rewriteBodyRes = ({
  r_rule: rRule,
  category_ids: categoryIds,
  ...rest
}) => ({
  ...rest,
  rRule,
  categoryIds
});
async function archiveMaintenanceWindow({
  http,
  maintenanceWindowId,
  archive
}) {
  const res = await http.post(`${_common.INTERNAL_BASE_ALERTING_API_PATH}/rules/maintenance_window/${encodeURIComponent(maintenanceWindowId)}/_archive`, {
    body: JSON.stringify({
      archive
    })
  });
  return rewriteBodyRes(res);
}