"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRandomDocsRequest = void 0;
var _get_query_with_params = require("./get_query_with_params");
var _get_request_base = require("./get_request_base");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const POPULATED_DOC_COUNT_SAMPLE_SIZE = 1000;
const getRandomDocsRequest = params => ({
  ...(0, _get_request_base.getRequestBase)(params),
  body: {
    fields: ['*'],
    _source: false,
    query: {
      function_score: {
        query: (0, _get_query_with_params.getQueryWithParams)({
          params
        }),
        // @ts-ignore
        random_score: {}
      }
    },
    size: POPULATED_DOC_COUNT_SAMPLE_SIZE,
    // Used to determine sample probability for follow up queries
    track_total_hits: true
  }
});
exports.getRandomDocsRequest = getRandomDocsRequest;