"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EmbeddableChangePointChartFactory = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _public = require("@kbn/embeddable-plugin/public");
var _i18n = require("@kbn/i18n");
var _constants = require("../../common/constants");
var _embeddable_change_point_chart = require("./embeddable_change_point_chart");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; } /*
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0; you may not use this file except in compliance with the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */
class EmbeddableChangePointChartFactory {
  constructor(getStartServices) {
    (0, _defineProperty2.default)(this, "type", _constants.EMBEDDABLE_CHANGE_POINT_CHART_TYPE);
    (0, _defineProperty2.default)(this, "grouping", [{
      id: 'ml',
      getDisplayName: () => _i18n.i18n.translate('xpack.aiops.navMenu.mlAppNameText', {
        defaultMessage: 'Machine Learning'
      }),
      getIconType: () => 'machineLearningApp'
    }]);
    (0, _defineProperty2.default)(this, "isEditable", async () => {
      return true;
    });
    this.getStartServices = getStartServices;
  }
  getDisplayName() {
    return _i18n.i18n.translate('xpack.aiops.embeddableChangePointChartDisplayName', {
      defaultMessage: 'Change point detection'
    });
  }
  canCreateNew() {
    return true;
  }
  async getExplicitInput() {
    const [coreStart, pluginStart] = await this.getStartServices();
    try {
      const {
        resolveEmbeddableChangePointUserInput
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./handle_explicit_input')));
      return await resolveEmbeddableChangePointUserInput(coreStart, pluginStart);
    } catch (e) {
      return Promise.reject();
    }
  }
  async create(input, parent) {
    try {
      const [{
        i18n: i18nService,
        theme,
        http,
        uiSettings,
        notifications
      }, {
        lens,
        data,
        usageCollection
      }] = await this.getStartServices();
      return new _embeddable_change_point_chart.EmbeddableChangePointChart({
        theme,
        http,
        i18n: i18nService,
        uiSettings,
        data,
        notifications,
        lens,
        usageCollection
      }, input, parent);
    } catch (e) {
      return new _public.ErrorEmbeddable(e, input, parent);
    }
  }
}
exports.EmbeddableChangePointChartFactory = EmbeddableChangePointChartFactory;