"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PageHeader = void 0;
var _react = require("@emotion/react");
var _react2 = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _mlUrlState = require("@kbn/ml-url-state");
var _mlLocalStorage = require("@kbn/ml-local-storage");
var _mlDatePicker = require("@kbn/ml-date-picker");
var _moment = _interopRequireDefault(require("moment"));
var _use_data_source = require("../../hooks/use_data_source");
var _storage = require("../../types/storage");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const dataViewTitleHeader = (0, _react.css)({
  minWidth: '300px'
});
const PageHeader = () => {
  const [, setGlobalState] = (0, _mlUrlState.useUrlState)('_g');
  const {
    dataView
  } = (0, _use_data_source.useDataSource)();
  const [frozenDataPreference, setFrozenDataPreference] = (0, _mlLocalStorage.useStorage)(_storage.AIOPS_FROZEN_TIER_PREFERENCE,
  // By default we will exclude frozen data tier
  _mlDatePicker.FROZEN_TIER_PREFERENCE.EXCLUDE);
  const timefilter = (0, _mlDatePicker.useTimefilter)({
    timeRangeSelector: dataView.timeFieldName !== undefined,
    autoRefreshSelector: true
  });
  const updateTimeState = (0, _react2.useCallback)(update => {
    setGlobalState({
      time: {
        from: (0, _moment.default)(update.start.epoch).toISOString(),
        to: (0, _moment.default)(update.end.epoch).toISOString()
      }
    });
  }, [setGlobalState]);
  const hasValidTimeField = (0, _react2.useMemo)(() => dataView.timeFieldName !== undefined && dataView.timeFieldName !== '', [dataView.timeFieldName]);
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiPageHeader, {
    pageTitle: /*#__PURE__*/_react2.default.createElement("div", {
      css: dataViewTitleHeader
    }, dataView.getName()),
    rightSideItems: [/*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      "data-test-subj": "aiopsTimeRangeSelectorSection"
    }, hasValidTimeField ? /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react2.default.createElement(_mlDatePicker.FullTimeRangeSelector, {
      frozenDataPreference: frozenDataPreference,
      setFrozenDataPreference: setFrozenDataPreference,
      dataView: dataView,
      query: undefined,
      disabled: false,
      timefilter: timefilter,
      callback: updateTimeState
    })) : null, /*#__PURE__*/_react2.default.createElement(_mlDatePicker.DatePickerWrapper, {
      isAutoRefreshOnly: !hasValidTimeField,
      showRefresh: !hasValidTimeField,
      width: "full",
      flexGroup: false
    }))]
  });
};
exports.PageHeader = PageHeader;