"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useViewInDiscoverAction = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _mlQueryUtils = require("@kbn/ml-query-utils");
var _use_aiops_app_context = require("../../hooks/use_aiops_app_context");
var _table_action_button = require("./table_action_button");
var _get_table_item_as_kql = require("./get_table_item_as_kql");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const viewInDiscoverMessage = _i18n.i18n.translate('xpack.aiops.logRateAnalysis.resultsTable.linksMenu.viewInDiscover', {
  defaultMessage: 'View in Discover'
});
const useViewInDiscoverAction = dataViewId => {
  var _application$capabili2;
  const {
    application,
    share,
    data
  } = (0, _use_aiops_app_context.useAiopsAppContext)();
  const discoverLocator = (0, _react.useMemo)(() => share.url.locators.get('DISCOVER_APP_LOCATOR'), [share.url.locators]);
  const discoverUrlError = (0, _react.useMemo)(() => {
    var _application$capabili;
    if (!((_application$capabili = application.capabilities.discover) !== null && _application$capabili !== void 0 && _application$capabili.show)) {
      const discoverNotEnabled = _i18n.i18n.translate('xpack.aiops.logRateAnalysis.resultsTable.discoverNotEnabledErrorMessage', {
        defaultMessage: 'Discover is not enabled'
      });
      return discoverNotEnabled;
    }
    if (!discoverLocator) {
      const discoverLocatorMissing = _i18n.i18n.translate('xpack.aiops.logRateAnalysis.resultsTable.discoverLocatorMissingErrorMessage', {
        defaultMessage: 'No locator for Discover detected'
      });
      return discoverLocatorMissing;
    }
    if (!dataViewId) {
      const autoGeneratedDiscoverLinkError = _i18n.i18n.translate('xpack.aiops.logRateAnalysis.resultsTable.autoGeneratedDiscoverLinkErrorMessage', {
        defaultMessage: 'Unable to link to Discover; no data view exists for this index'
      });
      return autoGeneratedDiscoverLinkError;
    }
  }, [(_application$capabili2 = application.capabilities.discover) === null || _application$capabili2 === void 0 ? void 0 : _application$capabili2.show, dataViewId, discoverLocator]);
  const generateDiscoverUrl = async groupTableItem => {
    if (discoverLocator !== undefined) {
      const url = await discoverLocator.getRedirectUrl({
        indexPatternId: dataViewId,
        timeRange: data.query.timefilter.timefilter.getTime(),
        filters: data.query.filterManager.getFilters(),
        query: {
          language: _mlQueryUtils.SEARCH_QUERY_LANGUAGE.KUERY,
          query: (0, _get_table_item_as_kql.getTableItemAsKQL)(groupTableItem)
        }
      });
      return url;
    }
  };
  return {
    render: tableItem => {
      const tooltipText = discoverUrlError ? discoverUrlError : viewInDiscoverMessage;
      const clickHandler = async () => {
        const openInDiscoverUrl = await generateDiscoverUrl(tableItem);
        if (typeof openInDiscoverUrl === 'string') {
          await application.navigateToUrl(openInDiscoverUrl);
        }
      };
      return /*#__PURE__*/_react.default.createElement(_table_action_button.TableActionButton, {
        dataTestSubjPostfix: "Discover",
        iconType: "discoverApp",
        isDisabled: discoverUrlError !== undefined,
        label: viewInDiscoverMessage,
        tooltipText: tooltipText,
        onClick: clickHandler
      });
    }
  };
};
exports.useViewInDiscoverAction = useViewInDiscoverAction;