"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLogRateAnalysisResultsTableRowContext = exports.logRateAnalysisResultsTableRowContext = exports.LogRateAnalysisResultsTableRowStateProvider = void 0;
var _react = _interopRequireWildcard(require("react"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const logRateAnalysisResultsTableRowContext = /*#__PURE__*/(0, _react.createContext)(undefined);
exports.logRateAnalysisResultsTableRowContext = logRateAnalysisResultsTableRowContext;
const LogRateAnalysisResultsTableRowStateProvider = ({
  children
}) => {
  // State that will be shared with all components
  const [pinnedSignificantItem, setPinnedSignificantItem] = (0, _react.useState)(null);
  const [pinnedGroup, setPinnedGroup] = (0, _react.useState)(null);
  const [selectedSignificantItem, setSelectedSignificantItem] = (0, _react.useState)(null);
  const [selectedGroup, setSelectedGroup] = (0, _react.useState)(null);

  // If a row is pinned, still overrule with a potentially hovered row.
  const currentSelectedSignificantItem = (0, _react.useMemo)(() => {
    if (selectedSignificantItem) {
      return selectedSignificantItem;
    } else if (pinnedSignificantItem) {
      return pinnedSignificantItem;
    }
  }, [pinnedSignificantItem, selectedSignificantItem]);

  // If a group is pinned, still overrule with a potentially hovered group.
  const currentSelectedGroup = (0, _react.useMemo)(() => {
    if (selectedGroup) {
      return selectedGroup;
    } else if (pinnedGroup) {
      return pinnedGroup;
    }
  }, [selectedGroup, pinnedGroup]);
  const contextValue = (0, _react.useMemo)(() => ({
    pinnedSignificantItem,
    setPinnedSignificantItem,
    pinnedGroup,
    setPinnedGroup,
    selectedSignificantItem,
    setSelectedSignificantItem,
    selectedGroup,
    setSelectedGroup,
    currentSelectedSignificantItem,
    currentSelectedGroup,
    clearAllRowState: () => {
      setPinnedSignificantItem(null);
      setPinnedGroup(null);
      setSelectedSignificantItem(null);
      setSelectedGroup(null);
    }
  }), [pinnedSignificantItem, setPinnedSignificantItem, pinnedGroup, setPinnedGroup, selectedSignificantItem, setSelectedSignificantItem, selectedGroup, setSelectedGroup, currentSelectedSignificantItem, currentSelectedGroup]);
  return (
    /*#__PURE__*/
    // Provider managing the state
    _react.default.createElement(logRateAnalysisResultsTableRowContext.Provider, {
      value: contextValue
    }, children)
  );
};
exports.LogRateAnalysisResultsTableRowStateProvider = LogRateAnalysisResultsTableRowStateProvider;
const useLogRateAnalysisResultsTableRowContext = () => {
  const logRateAnalysisResultsTableRow = (0, _react.useContext)(logRateAnalysisResultsTableRowContext);

  // If `undefined`, throw an error.
  if (logRateAnalysisResultsTableRow === undefined) {
    throw new Error('useLogRateAnalysisResultsTableRowContext was used outside of its Provider');
  }
  return logRateAnalysisResultsTableRow;
};
exports.useLogRateAnalysisResultsTableRowContext = useLogRateAnalysisResultsTableRowContext;