"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogRateAnalysisContentWrapper = void 0;
var _react = _interopRequireDefault(require("react"));
var _lodash = require("lodash");
var _mlLocalStorage = require("@kbn/ml-local-storage");
var _mlUrlState = require("@kbn/ml-url-state");
var _public = require("@kbn/kibana-utils-plugin/public");
var _mlDatePicker = require("@kbn/ml-date-picker");
var _common = require("@kbn/data-plugin/common");
var _time_series_dataview_check = require("../../../application/utils/time_series_dataview_check");
var _use_aiops_app_context = require("../../../hooks/use_aiops_app_context");
var _use_data_source = require("../../../hooks/use_data_source");
var _storage = require("../../../types/storage");
var _log_rate_analysis_results_table_row_provider = require("../../log_rate_analysis_results_table/log_rate_analysis_results_table_row_provider");
var _log_rate_analysis_content = require("./log_rate_analysis_content");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const localStorage = new _public.Storage(window.localStorage);

/**
 * Props for the LogRateAnalysisContentWrapper component.
 */

const LogRateAnalysisContentWrapper = ({
  dataView,
  appDependencies,
  setGlobalState,
  initialAnalysisStart,
  timeRange,
  esSearchQuery,
  stickyHistogram,
  barColorOverride,
  barHighlightColorOverride,
  onAnalysisCompleted,
  showFrozenDataTierChoice = true,
  embeddingOrigin
}) => {
  if (!dataView) return null;
  const warning = (0, _time_series_dataview_check.timeSeriesDataViewWarning)(dataView, 'log_rate_analysis');
  if (warning !== null) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, warning);
  }
  const datePickerDeps = {
    ...(0, _lodash.pick)(appDependencies, ['data', 'http', 'notifications', 'theme', 'uiSettings', 'i18n']),
    uiSettingsKeys: _common.UI_SETTINGS,
    showFrozenDataTierChoice
  };
  return /*#__PURE__*/_react.default.createElement(_use_aiops_app_context.AiopsAppContext.Provider, {
    value: appDependencies
  }, /*#__PURE__*/_react.default.createElement(_mlUrlState.UrlStateProvider, null, /*#__PURE__*/_react.default.createElement(_use_data_source.DataSourceContext.Provider, {
    value: {
      dataView,
      savedSearch: null
    }
  }, /*#__PURE__*/_react.default.createElement(_log_rate_analysis_results_table_row_provider.LogRateAnalysisResultsTableRowStateProvider, null, /*#__PURE__*/_react.default.createElement(_mlLocalStorage.StorageContextProvider, {
    storage: localStorage,
    storageKeys: _storage.AIOPS_STORAGE_KEYS
  }, /*#__PURE__*/_react.default.createElement(_mlDatePicker.DatePickerContextProvider, datePickerDeps, /*#__PURE__*/_react.default.createElement(_log_rate_analysis_content.LogRateAnalysisContent, {
    dataView: dataView,
    setGlobalState: setGlobalState,
    initialAnalysisStart: initialAnalysisStart,
    timeRange: timeRange,
    esSearchQuery: esSearchQuery,
    stickyHistogram: stickyHistogram,
    barColorOverride: barColorOverride,
    barHighlightColorOverride: barHighlightColorOverride,
    onAnalysisCompleted: onAnalysisCompleted,
    embeddingOrigin: embeddingOrigin
  })))))));
};
exports.LogRateAnalysisContentWrapper = LogRateAnalysisContentWrapper;