"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldFilterApplyButton = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FieldFilterApplyButton = ({
  disabled,
  onClick,
  tooltipContent
}) => {
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": `aiopsFieldFilterApplyButton${disabled ? ' disabled' : ''}`,
    size: "s",
    onClick: onClick,
    disabled: disabled
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.aiops.logRateAnalysis.page.fieldFilterApplyButtonLabel",
    defaultMessage: "Apply"
  }));
  if (tooltipContent) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "left",
      content: tooltipContent
    }, button);
  }
  return button;
};
exports.FieldFilterApplyButton = FieldFilterApplyButton;