"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCategorizeRequest = useCategorizeRequest;
var _react = require("react");
var _public = require("@kbn/data-plugin/public");
var _mlLocalStorage = require("@kbn/ml-local-storage");
var _create_category_request = require("../../../common/api/log_categorization/create_category_request");
var _process_category_results = require("../../../common/api/log_categorization/process_category_results");
var _use_aiops_app_context = require("../../hooks/use_aiops_app_context");
var _storage = require("../../types/storage");
var _sampling_menu = require("./sampling_menu");
var _random_sampler = require("./sampling_menu/random_sampler");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useCategorizeRequest() {
  const [randomSamplerMode, setRandomSamplerMode] = (0, _mlLocalStorage.useStorage)(_storage.AIOPS_RANDOM_SAMPLING_MODE_PREFERENCE, _random_sampler.RANDOM_SAMPLER_OPTION.ON_AUTOMATIC);
  const [randomSamplerProbability, setRandomSamplerProbability] = (0, _mlLocalStorage.useStorage)(_storage.AIOPS_RANDOM_SAMPLING_PROBABILITY_PREFERENCE, _random_sampler.DEFAULT_PROBABILITY);
  const {
    data
  } = (0, _use_aiops_app_context.useAiopsAppContext)();
  const abortController = (0, _react.useRef)(new AbortController());
  const randomSampler = (0, _react.useMemo)(() => new _sampling_menu.RandomSampler(randomSamplerMode, setRandomSamplerMode, randomSamplerProbability, setRandomSamplerProbability),
  // eslint-disable-next-line react-hooks/exhaustive-deps
  []);
  const runCategorizeRequest = (0, _react.useCallback)((index, field, timeField, timeRange, query, intervalMs, additionalFilter) => {
    const {
      wrap,
      unwrap
    } = randomSampler.createRandomSamplerWrapper();
    return new Promise((resolve, reject) => {
      data.search.search((0, _create_category_request.createCategoryRequest)(index, field, timeField, timeRange, query, wrap, intervalMs, additionalFilter), {
        abortSignal: abortController.current.signal
      }).subscribe({
        next: result => {
          if (!(0, _public.isRunningResponse)(result)) {
            resolve((0, _process_category_results.processCategoryResults)(result, field, unwrap));
          } else {
            // partial results
            // Ignore partial results for now.
            // An issue with the search function means partial results are not being returned correctly.
          }
        },
        error: error => {
          if (error.name === 'AbortError') {
            return resolve({
              categories: []
            });
          }
          reject(error);
        }
      });
    });
  }, [data.search, randomSampler]);
  const cancelRequest = (0, _react.useCallback)(() => {
    abortController.current.abort();
    abortController.current = new AbortController();
  }, []);
  return {
    runCategorizeRequest,
    cancelRequest,
    randomSampler
  };
}