"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createCategorizeFieldAction = void 0;
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/ui-actions-plugin/public");
var _mlUiActions = require("@kbn/ml-ui-actions");
var _show_flyout = require("./show_flyout");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createCategorizeFieldAction = (coreStart, plugins) => (0, _public.createAction)({
  type: _mlUiActions.ACTION_CATEGORIZE_FIELD,
  id: _mlUiActions.ACTION_CATEGORIZE_FIELD,
  getDisplayName: () => _i18n.i18n.translate('xpack.aiops.categorizeFieldAction.displayName', {
    defaultMessage: 'Pattern analysis'
  }),
  isCompatible: async ({
    field
  }) => {
    var _field$esTypes;
    return ((_field$esTypes = field.esTypes) === null || _field$esTypes === void 0 ? void 0 : _field$esTypes.includes('text')) === true;
  },
  execute: async context => {
    const {
      field,
      dataView,
      originatingApp,
      additionalFilter
    } = context;
    (0, _show_flyout.showCategorizeFlyout)(field, dataView, coreStart, plugins, originatingApp, additionalFilter);
  }
});
exports.createCategorizeFieldAction = createCategorizeFieldAction;