"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchBarWrapper = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _esQuery = require("@kbn/es-query");
var _eui = require("@elastic/eui");
var _mlQueryUtils = require("@kbn/ml-query-utils");
var _use_data_source = require("../../hooks/use_data_source");
var _use_aiops_app_context = require("../../hooks/use_aiops_app_context");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Reusable search bar component for the AIOps app.
 *
 * @param query
 * @param filters
 * @param onQueryChange
 * @param onFiltersChange
 * @constructor
 */
const SearchBarWrapper = ({
  query,
  filters,
  onQueryChange,
  onFiltersChange
}) => {
  const {
    dataView
  } = (0, _use_data_source.useDataSource)();
  const {
    unifiedSearch: {
      ui: {
        SearchBar
      }
    }
  } = (0, _use_aiops_app_context.useAiopsAppContext)();
  const [error, setError] = (0, _react.useState)();
  const onQuerySubmit = (0, _react.useCallback)((payload, isUpdate) => {
    if (payload.query.language === _mlQueryUtils.SEARCH_QUERY_LANGUAGE.KUERY) {
      try {
        // Validates the query
        (0, _esQuery.fromKueryExpression)(payload.query.query);
        setError(undefined);
        onQueryChange(payload.query);
      } catch (e) {
        setError(e.message);
      }
    }
  }, [onQueryChange]);
  const onFiltersUpdated = (0, _react.useCallback)(updatedFilters => {
    onFiltersChange(updatedFilters);
  }, [onFiltersChange]);
  const resultQuery = query !== null && query !== void 0 ? query : {
    query: '',
    language: 'kuery'
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(SearchBar, {
    showSubmitButton: false,
    appName: 'aiops',
    showFilterBar: true,
    showDatePicker: false,
    showQueryInput: true,
    query: resultQuery,
    filters: filters !== null && filters !== void 0 ? filters : [],
    onQuerySubmit: onQuerySubmit,
    indexPatterns: [dataView],
    placeholder: _i18n.i18n.translate('xpack.aiops.searchPanel.queryBarPlaceholderText', {
      defaultMessage: 'Search… (e.g. status:200 AND extension:"PHP")'
    }),
    displayStyle: 'inPage',
    isClearable: true,
    onFiltersUpdated: onFiltersUpdated
  }), error ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 's'
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "danger"
  }, error)) : null);
};
exports.SearchBarWrapper = SearchBarWrapper;