"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricFieldSelector = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _change_point_detection_context = require("./change_point_detection_context");
var _use_aiops_app_context = require("../../hooks/use_aiops_app_context");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MetricFieldSelector = /*#__PURE__*/_react.default.memo(({
  value,
  onChange,
  inline = true
}) => {
  var _fieldStats$useFieldS;
  const {
    fieldStats
  } = (0, _use_aiops_app_context.useAiopsAppContext)();
  const {
    metricFieldOptions
  } = (0, _change_point_detection_context.useChangePointDetectionControlsContext)();
  const {
    renderOption,
    closeFlyout
  } = (_fieldStats$useFieldS = fieldStats === null || fieldStats === void 0 ? void 0 : fieldStats.useFieldStatsTrigger()) !== null && _fieldStats$useFieldS !== void 0 ? _fieldStats$useFieldS : {};
  const options = (0, _react.useMemo)(() => {
    return metricFieldOptions.map(v => {
      return {
        value: v.name,
        label: v.displayName,
        field: {
          id: v.name,
          type: v.type
        }
      };
    });
  }, [metricFieldOptions]);
  const selection = options.filter(v => v.value === value);
  const onChangeCallback = (0, _react.useCallback)(selectedOptions => {
    const option = selectedOptions[0];
    if (typeof option !== 'undefined') {
      onChange(option.value);
    }
    if (closeFlyout) {
      closeFlyout();
    }
  }, [onChange, closeFlyout]);
  const label = _i18n.i18n.translate('xpack.aiops.changePointDetection.selectMetricFieldLabel', {
    defaultMessage: 'Metric field'
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: inline ? undefined : label
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    fullWidth: true,
    compressed: true,
    prepend: inline ? label : undefined,
    singleSelection: {
      asPlainText: true
    },
    options: options,
    selectedOptions: selection,
    onChange: onChangeCallback,
    isClearable: false,
    "data-test-subj": "aiopsChangePointMetricField",
    renderOption: renderOption
  })));
});
exports.MetricFieldSelector = MetricFieldSelector;