"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChartComponent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _use_common_chart_props = require("./use_common_chart_props");
var _use_aiops_app_context = require("../../hooks/use_aiops_app_context");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ChartComponent = /*#__PURE__*/_react.default.memo(({
  annotation,
  fieldConfig,
  interval,
  onLoading,
  onRenderComplete
}) => {
  const {
    lens: {
      EmbeddableComponent
    }
  } = (0, _use_aiops_app_context.useAiopsAppContext)();
  const chartWrapperRef = (0, _react.useRef)(null);
  const renderCompleteListener = (0, _react.useCallback)(event => {
    if (event.target === chartWrapperRef.current) return;
    if (onRenderComplete) {
      onRenderComplete();
    }
  }, [onRenderComplete]);
  (0, _react.useEffect)(() => {
    if (!chartWrapperRef.current) {
      throw new Error('Reference to the chart wrapper is not set');
    }
    const chartWrapper = chartWrapperRef.current;
    chartWrapper.addEventListener('renderComplete', renderCompleteListener);
    return () => {
      chartWrapper.removeEventListener('renderComplete', renderCompleteListener);
    };
  }, [renderCompleteListener]);
  const {
    filters,
    timeRange,
    query,
    attributes
  } = (0, _use_common_chart_props.useCommonChartProps)({
    fieldConfig,
    annotation,
    bucketInterval: interval
  });
  return /*#__PURE__*/_react.default.createElement("div", {
    ref: chartWrapperRef
  }, /*#__PURE__*/_react.default.createElement(EmbeddableComponent, {
    id: `changePointChart_${annotation.group ? annotation.group.value : annotation.label}`,
    style: {
      height: 350
    },
    timeRange: timeRange,
    query: query,
    filters: filters
    // @ts-ignore
    ,
    attributes: attributes,
    renderMode: 'view',
    executionContext: {
      type: 'aiops_change_point_detection_chart',
      name: 'Change point detection'
    },
    disableTriggers: true,
    onLoad: onLoading
  }));
});
exports.ChartComponent = ChartComponent;