"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.runtimeMappingsSchema = exports.indicesOptionsSchema = exports.categorizeSchema = exports.categorizationFieldValidationSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _i18n = require("@kbn/i18n");
var _mlRuntimeFieldUtils = require("@kbn/ml-runtime-field-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const runtimeMappingsSchema = _configSchema.schema.object({}, {
  unknowns: 'allow',
  validate: v => {
    if (Object.values(v).some(o => !(0, _mlRuntimeFieldUtils.isRuntimeField)(o))) {
      return _i18n.i18n.translate('xpack.aiops.invalidRuntimeFieldMessage', {
        defaultMessage: 'Invalid runtime field'
      });
    }
  }
});
exports.runtimeMappingsSchema = runtimeMappingsSchema;
const indicesOptionsSchema = _configSchema.schema.object({
  expand_wildcards: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.oneOf([_configSchema.schema.literal('all'), _configSchema.schema.literal('open'), _configSchema.schema.literal('closed'), _configSchema.schema.literal('hidden'), _configSchema.schema.literal('none')]))),
  ignore_unavailable: _configSchema.schema.maybe(_configSchema.schema.boolean()),
  allow_no_indices: _configSchema.schema.maybe(_configSchema.schema.boolean()),
  ignore_throttled: _configSchema.schema.maybe(_configSchema.schema.boolean())
});
exports.indicesOptionsSchema = indicesOptionsSchema;
const categorizeSchema = _configSchema.schema.object({
  index: _configSchema.schema.string(),
  field: _configSchema.schema.string(),
  timeField: _configSchema.schema.string(),
  to: _configSchema.schema.number(),
  from: _configSchema.schema.number(),
  query: _configSchema.schema.any(),
  intervalMs: _configSchema.schema.maybe(_configSchema.schema.number())
});
exports.categorizeSchema = categorizeSchema;
const categorizationFieldValidationSchema = _configSchema.schema.object({
  indexPatternTitle: _configSchema.schema.string(),
  query: _configSchema.schema.any(),
  size: _configSchema.schema.number(),
  field: _configSchema.schema.string(),
  timeField: _configSchema.schema.maybe(_configSchema.schema.string()),
  start: _configSchema.schema.number(),
  end: _configSchema.schema.number(),
  analyzer: _configSchema.schema.maybe(_configSchema.schema.any()),
  runtimeMappings: runtimeMappingsSchema,
  indicesOptions: indicesOptionsSchema,
  includeExamples: _configSchema.schema.boolean()
});
exports.categorizationFieldValidationSchema = categorizationFieldValidationSchema;