"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AiAssistantManagementObservabilityPlugin = void 0;
var _i18n = require("@kbn/i18n");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; } /*
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0 and the Server Side Public License, v 1; you may not use this file except
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * in compliance with, at your election, the Elastic License 2.0 or the Server
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Side Public License, v 1.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */
// eslint-disable-next-line @typescript-eslint/no-empty-interface

// eslint-disable-next-line @typescript-eslint/no-empty-interface

class AiAssistantManagementObservabilityPlugin {
  setup(core, {
    home,
    management,
    observabilityAIAssistant
  }) {
    const title = _i18n.i18n.translate('aiAssistantManagementObservability.app.title', {
      defaultMessage: 'AI Assistant for Observability'
    });
    if (home) {
      home.featureCatalogue.register({
        id: 'ai_assistant_observability',
        title,
        description: _i18n.i18n.translate('aiAssistantManagementObservability.app.description', {
          defaultMessage: 'Manage your AI Assistant for Observability.'
        }),
        icon: 'sparkles',
        path: '/app/management/kibana/ai-assistant/observability',
        showOnHomePage: false,
        category: 'admin'
      });
    }
    if (observabilityAIAssistant) {
      management.sections.section.kibana.registerApp({
        id: 'aiAssistantManagementObservability',
        title,
        hideFromSidebar: true,
        order: 1,
        mount: async mountParams => {
          const {
            mountManagementSection
          } = await Promise.resolve().then(() => _interopRequireWildcard(require('./app')));
          return mountManagementSection({
            core,
            mountParams
          });
        }
      });
    }
    return {};
  }
  start() {
    return {};
  }
}
exports.AiAssistantManagementObservabilityPlugin = AiAssistantManagementObservabilityPlugin;