"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGetKnowledgeBaseEntries = useGetKnowledgeBaseEntries;
var _reactQuery = require("@tanstack/react-query");
var _constants = require("../constants");
var _use_app_context = require("./use_app_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function useGetKnowledgeBaseEntries({
  query,
  sortBy,
  sortDirection
}) {
  const {
    observabilityAIAssistant
  } = (0, _use_app_context.useAppContext)();
  const observabilityAIAssistantApi = observabilityAIAssistant.service.callApi;
  const {
    isLoading,
    isError,
    isSuccess,
    isRefetching,
    data,
    refetch
  } = (0, _reactQuery.useQuery)({
    queryKey: [_constants.REACT_QUERY_KEYS.GET_KB_ENTRIES, query, sortBy, sortDirection],
    queryFn: async ({
      signal
    }) => {
      if (!observabilityAIAssistantApi || !signal) {
        return Promise.reject('Error with observabilityAIAssistantApi: API not found.');
      }
      return observabilityAIAssistantApi(`GET /internal/observability_ai_assistant/kb/entries`, {
        signal,
        params: {
          query: {
            query,
            sortBy,
            sortDirection
          }
        }
      });
    },
    keepPreviousData: true,
    refetchOnWindowFocus: false
  });
  return {
    entries: data === null || data === void 0 ? void 0 : data.entries,
    refetch,
    isLoading,
    isRefetching,
    isSuccess,
    isError
  };
}