"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.rawConnectorSchema = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const rawConnectorSchema = _configSchema.schema.object({
  actionTypeId: _configSchema.schema.string(),
  name: _configSchema.schema.string(),
  isMissingSecrets: _configSchema.schema.boolean(),
  config: _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.any()),
  secrets: _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.any()),
  isPreconfigured: _configSchema.schema.maybe(_configSchema.schema.boolean()),
  isSystemAction: _configSchema.schema.maybe(_configSchema.schema.boolean()),
  id: _configSchema.schema.maybe(_configSchema.schema.string()),
  isDeprecated: _configSchema.schema.maybe(_configSchema.schema.boolean())
});
exports.rawConnectorSchema = rawConnectorSchema;