"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setEuiDevProviderWarning = exports.getEuiDevProviderWarning = exports.emitEuiProviderWarning = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var providerWarning = undefined;
var setEuiDevProviderWarning = function setEuiDevProviderWarning(level) {
  return providerWarning = level;
};
exports.setEuiDevProviderWarning = setEuiDevProviderWarning;
var getEuiDevProviderWarning = function getEuiDevProviderWarning() {
  return providerWarning;
};

// Not a public top-level EUI export, currently for internal use
exports.getEuiDevProviderWarning = getEuiDevProviderWarning;
var emitEuiProviderWarning = function emitEuiProviderWarning(providerMessage) {
  switch (providerWarning) {
    case 'log':
      console.log(providerMessage);
      break;
    case 'warn':
      console.warn(providerMessage);
      break;
    case 'error':
      throw new Error(providerMessage);
    case undefined:
    default:
      break;
  }
};
exports.emitEuiProviderWarning = emitEuiProviderWarning;