"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CanvasTextUtils = void 0;
function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
/**
 * Creates a temporary Canvas element for manipulating text & determining text width.
 *
 * To accurately measure text, canvas rendering requires either a container to
 * compute/derive font styles from, or a static font string (useful for usage
 * outside the DOM). Particular care should be applied when fallback fonts are
 * used, as more fallback fonts can lead to less precision.
 *
 * Please note that while canvas is more significantly more performant than DOM
 * measurement, there are subpixel to single digit pixel differences between
 * DOM and canvas measurement due to the different rendering engines used.
 */
var CanvasTextUtils = /*#__PURE__*/function () {
  function CanvasTextUtils(_ref) {
    var _this = this;
    var font = _ref.font,
      container = _ref.container;
    _classCallCheck(this, CanvasTextUtils);
    _defineProperty(this, "context", void 0);
    _defineProperty(this, "currentText", '');
    _defineProperty(this, "computeFontFromElement", function (element) {
      var computedStyles = window.getComputedStyle(element);
      // TODO: font-stretch is not included even though it potentially should be
      // @see https://developer.mozilla.org/en-US/docs/Web/CSS/font#constituent_properties
      // It appears to be unsupported and/or breaks font computation in canvas
      return ['font-style', 'font-variant', 'font-weight', 'font-size', 'font-family'].map(function (prop) {
        return computedStyles.getPropertyValue(prop);
      }).join(' ').trim();
    });
    _defineProperty(this, "setTextToCheck", function (text) {
      _this.currentText = text;
    });
    this.context = document.createElement('canvas').getContext('2d');

    // Set the canvas font to ensure text width calculations are correct
    if (font) {
      this.context.font = font;
    } else if (container) {
      this.context.font = this.computeFontFromElement(container);
    }
  }
  _createClass(CanvasTextUtils, [{
    key: "textWidth",
    get: function get() {
      return this.context.measureText(this.currentText).width;
    }
  }]);
  return CanvasTextUtils;
}();
exports.CanvasTextUtils = CanvasTextUtils;