"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.logicals = exports.logicalTextAlignStyle = exports.logicalTextAlignCSS = exports.logicalText = exports.logicalStyles = exports.logicalStyle = exports.logicalSizeStyle = exports.logicalSizeCSS = exports.logicalSide = exports.logicalCSSWithFallback = exports.logicalCSS = exports.LOGICAL_TEXT_ALIGNMENT = exports.LOGICAL_SIDES = exports.LOGICAL_PROPERTIES = void 0;
var _common = require("../../components/common");
var _logicals2 = _interopRequireDefault(require("./logicals.json"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function _iterableToArrayLimit(arr, i) { var _i = null == arr ? null : "undefined" != typeof Symbol && arr[Symbol.iterator] || arr["@@iterator"]; if (null != _i) { var _s, _e, _x, _r, _arr = [], _n = !0, _d = !1; try { if (_x = (_i = _i.call(arr)).next, 0 === i) { if (Object(_i) !== _i) return; _n = !1; } else for (; !(_n = (_s = _x.call(_i)).done) && (_arr.push(_s.value), _arr.length !== i); _n = !0); } catch (err) { _d = !0, _e = err; } finally { try { if (!_n && null != _i.return && (_r = _i.return(), Object(_r) !== _r)) return; } finally { if (_d) throw _e; } } return _arr; } }
function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }
function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; } /*
                                                                                                                                                                                                                                                                                                                     * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                     * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                     * 2.0 and the Server Side Public License, v 1; you may not use this file except
                                                                                                                                                                                                                                                                                                                     * in compliance with, at your election, the Elastic License 2.0 or the Server
                                                                                                                                                                                                                                                                                                                     * Side Public License, v 1.
                                                                                                                                                                                                                                                                                                                     */
/**
 * EUI utilizes logical CSS properties to enable directional writing-modes.
 * To encourage use of logical properties, we provide a few helper utilities to
 * convert certain directional properties to logical properties.
 * https://developer.mozilla.org/en-US/docs/Web/CSS/CSS_Logical_Properties
 */

var logicalSide = {
  left: 'inline-start',
  right: 'inline-end',
  top: 'block-start',
  bottom: 'block-end',
  horizontal: 'inline',
  vertical: 'block'
};
exports.logicalSide = logicalSide;
var LOGICAL_SIDES = (0, _common.keysOf)(logicalSide);
exports.LOGICAL_SIDES = LOGICAL_SIDES;
var logicals = _logicals2.default;
exports.logicals = logicals;
var _shorthands = _logicals2.default._shorthands,
  _logicals = _objectWithoutProperties(_logicals2.default, ["_shorthands"]);
var LOGICAL_PROPERTIES = (0, _common.keysOf)(_logicals);
exports.LOGICAL_PROPERTIES = LOGICAL_PROPERTIES;
/**
 *
 * @param property A string that is a valid CSS logical property
 * @param value String to output as the property value
 * @returns `string` Returns the logical CSS property version for the given `property: value` pair
 */
var logicalCSS = function logicalCSS(property, value) {
  return "".concat(logicals[property], ": ").concat(value, ";");
};

/**
 * Some logical properties are not yet fully supported by all browsers.
 * For those cases, we should use the old property as a fallback for
 * browsers missing support, while allowing supporting browsers to use
 * the logical properties.
 *
 * Examples:
 * https://caniuse.com/?search=overflow-block
 * https://caniuse.com/mdn-css_properties_float_flow_relative_values
 */
exports.logicalCSS = logicalCSS;
var logicalCSSWithFallback = function logicalCSSWithFallback(property, value) {
  return "\n  ".concat(property, ": ").concat(value, ";\n  ").concat(logicalCSS(property, value), "\n");
};

/**
 * Casing utils for swapping between camel case (style objs) and kebab case (CSS)
 */
exports.logicalCSSWithFallback = logicalCSSWithFallback;
var camelCase = function camelCase(kebabCasedString) {
  return kebabCasedString.replace(/-\w/g, function (str) {
    return str.charAt(1).toUpperCase();
  });
};
var kebabCase = function kebabCase(camelCasedString) {
  return camelCasedString.replace(/([a-z])([A-Z])/g, '$1-$2').toLowerCase();
};

/**
 *
 * @param property A string that is a valid CSS logical property
 * @param value String to output as the property value
 * @returns `object` Returns the logical CSS property version for the given `property: value` pair
 */
var logicalStyle = function logicalStyle(property, value) {
  return _defineProperty({}, camelCase(logicals[property]), value);
};

/**
 * Given a style object with any amount of unknown CSS properties,
 * find ones that can be converted to logical properties and convert them
 *
 * @param styleObject - A React object of camelCased styles
 * @returns `object`
 */
exports.logicalStyle = logicalStyle;
var logicalStyles = function logicalStyles(styleObject) {
  var logicalStyleObject = {};
  Object.entries(styleObject).forEach(function (_ref2) {
    var _ref3 = _slicedToArray(_ref2, 2),
      key = _ref3[0],
      value = _ref3[1];
    var cssProperty = kebabCase(key);
    if (logicals.hasOwnProperty(cssProperty)) {
      var logicalKey = camelCase(logicals[cssProperty]);
      logicalStyleObject[logicalKey] = value;
    } else {
      logicalStyleObject[key] = value;
    }
  });
  return logicalStyleObject;
};

/**
 *
 * @param width A string value for the LTR width
 * @param height A string value for the LTR height
 * @returns `string` Returns the logical CSS properties for height and width
 */
exports.logicalStyles = logicalStyles;
var logicalSizeCSS = function logicalSizeCSS(width) {
  var height = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : width;
  return "\n    ".concat(logicals.width, ": ").concat(width, ";\n    ").concat(logicals.height, ": ").concat(height, ";\n  ");
};

/**
 *
 * @param width A string value for the LTR width
 * @param height A string value for the LTR height
 * @returns `object` Returns the logical CSS properties for height and width
 */
exports.logicalSizeCSS = logicalSizeCSS;
var logicalSizeStyle = function logicalSizeStyle(width, height) {
  return _objectSpread(_objectSpread({}, logicalStyle('width', width)), logicalStyle('height', height));
};

// Text alignment is separate because its the value that changes not the property
exports.logicalSizeStyle = logicalSizeStyle;
var logicalText = {
  'text-align': {
    left: 'start',
    center: 'center',
    right: 'end'
  }
};
exports.logicalText = logicalText;
var LOGICAL_TEXT_ALIGNMENT = (0, _common.keysOf)(logicalText['text-align']);
exports.LOGICAL_TEXT_ALIGNMENT = LOGICAL_TEXT_ALIGNMENT;
/**
 *
 * @param property A string that is a valid CSS logical property
 * @param value String to output as the property value
 * @returns `string` Returns the logical CSS property version for the given `property: value` pair
 */
var logicalTextAlignCSS = function logicalTextAlignCSS(value) {
  return "text-align: ".concat(logicalText['text-align'][value], ";");
};

/**
 *
 * @param property A string that is a valid CSS logical property
 * @param value String to output as the property value
 * @returns `object` Returns the logical CSS property version for the given `property: value` pair
 */
exports.logicalTextAlignCSS = logicalTextAlignCSS;
var logicalTextAlignStyle = function logicalTextAlignStyle(value) {
  return {
    textAlign: logicalText['text-align'][value]
  };
};
exports.logicalTextAlignStyle = logicalTextAlignStyle;