"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiToolTipAnchor = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _tool_tip = require("./tool_tip.styles");
var _react2 = require("@emotion/react");
var _excluded = ["onBlur", "onFocus", "onMouseOver", "onMouseOut", "id", "className", "children", "display", "isVisible"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }
function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
var EuiToolTipAnchor = /*#__PURE__*/(0, _react.forwardRef)(function (_ref, ref) {
  var _onBlur = _ref.onBlur,
    _onFocus = _ref.onFocus,
    onMouseOver = _ref.onMouseOver,
    onMouseOut = _ref.onMouseOut,
    id = _ref.id,
    className = _ref.className,
    children = _ref.children,
    display = _ref.display,
    isVisible = _ref.isVisible,
    rest = _objectWithoutProperties(_ref, _excluded);
  var anchorCss = (0, _tool_tip.euiToolTipAnchorStyles)();
  var cssStyles = [anchorCss.euiToolTipAnchor, anchorCss[display]];
  var classes = (0, _classnames.default)('euiToolTipAnchor', className);
  return (
    // eslint-disable-next-line jsx-a11y/mouse-events-have-key-events
    (0, _react2.jsx)("span", _extends({
      ref: ref,
      css: cssStyles
    }, rest, {
      className: classes,
      onMouseOver: onMouseOver,
      onMouseOut: onMouseOut
    }), /*#__PURE__*/(0, _react.cloneElement)(children, {
      onFocus: function onFocus(e) {
        _onFocus();
        children.props.onFocus && children.props.onFocus(e);
      },
      onBlur: function onBlur(e) {
        _onBlur();
        children.props.onBlur && children.props.onBlur(e);
      },
      'aria-describedby': isVisible ? (0, _classnames.default)(id, children.props['aria-describedby']) : children.props['aria-describedby']
    }))
  );
});
exports.EuiToolTipAnchor = EuiToolTipAnchor;
EuiToolTipAnchor.propTypes = {
  onBlur: _propTypes.default.func.isRequired,
  onFocus: _propTypes.default.func.isRequired,
  isVisible: _propTypes.default.bool.isRequired
};
EuiToolTipAnchor.displayName = 'EuiToolTipAnchor';