"use strict";

var _react = _interopRequireDefault(require("react"));
var _tabbed_content = require("./tabbed_content");
var _spacer = require("../spacer");
var _text = require("../text");
var _react2 = require("@emotion/react");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); } /*
                                                                                                                                                                                                                                                                                                                                                                                               * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                                                               * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                               * 2.0 and the Server Side Public License, v 1; you may not use this file except
                                                                                                                                                                                                                                                                                                                                                                                               * in compliance with, at your election, the Elastic License 2.0 or the Server
                                                                                                                                                                                                                                                                                                                                                                                               * Side Public License, v 1.
                                                                                                                                                                                                                                                                                                                                                                                               */ /// <reference types="cypress" />
/// <reference types="cypress-real-events" />
/// <reference types="../../../cypress/support" />
var tabs = [{
  id: 'cobalt--id',
  name: 'Cobalt',
  content: (0, _react2.jsx)(_react.default.Fragment, null, (0, _react2.jsx)(_spacer.EuiSpacer, null), (0, _react2.jsx)(_text.EuiText, null, (0, _react2.jsx)("p", null, "Cobalt is a chemical element with symbol Co and atomic number 27. Like nickel, cobalt is found in the Earth\u2019s crust only in chemically combined form, save for small deposits found in alloys of natural meteoric iron. The free element, produced by reductive smelting, is a hard, lustrous, silver-gray metal.")))
}, {
  id: 'dextrose--id',
  name: 'Dextrose',
  content: (0, _react2.jsx)(_react.default.Fragment, null, (0, _react2.jsx)(_spacer.EuiSpacer, null), (0, _react2.jsx)(_text.EuiText, null, (0, _react2.jsx)("p", null, "Intravenous sugar solution, also known as dextrose solution, is a mixture of dextrose (glucose) and water. It is used to treat low blood sugar or water loss without electrolyte loss.")))
}, {
  id: 'hydrogen--id',
  name: 'Hydrogen',
  content: (0, _react2.jsx)(_react.default.Fragment, null, (0, _react2.jsx)(_spacer.EuiSpacer, null), (0, _react2.jsx)(_text.EuiText, null, (0, _react2.jsx)("p", null, "Hydrogen is a chemical element with symbol H and atomic number 1. With a standard atomic weight of 1.008, hydrogen is the lightest element on the periodic table")))
}, {
  id: 'monosodium_glutammate--id',
  name: 'Monosodium Glutamate',
  content: (0, _react2.jsx)(_react.default.Fragment, null, (0, _react2.jsx)(_spacer.EuiSpacer, null), (0, _react2.jsx)(_text.EuiText, null, (0, _react2.jsx)("p", null, "Monosodium glutamate (MSG, also known as sodium glutamate) is the sodium salt of glutamic acid, one of the most abundant naturally occurring non-essential amino acids. Monosodium glutamate is found naturally in tomatoes, cheese and other foods.")))
}];
var defaultTabProps = {
  tabs: tabs,
  initialSelectedTab: tabs[0],
  autoFocus: 'selected',
  onTabClick: function onTabClick() {}
};
describe('EuiTabs', function () {
  describe('Automated accessibility check', function () {
    it('has zero violations with default props', function () {
      cy.mount((0, _react2.jsx)(_tabbed_content.EuiTabbedContent, defaultTabProps));
      cy.get('div.euiTabs').should('exist');
      cy.checkAxe();
    });
    it('has zero violations with second tab open on render', function () {
      var secondSelectedTab = _objectSpread(_objectSpread({}, defaultTabProps), {}, {
        initialSelectedTab: tabs[1]
      });
      cy.mount((0, _react2.jsx)(_tabbed_content.EuiTabbedContent, secondSelectedTab));
      cy.get('div.euiTabs').should('exist');
      cy.checkAxe();
    });
    it('has zero violations with third tab open on render', function () {
      var thirdSelectedTab = _objectSpread(_objectSpread({}, defaultTabProps), {}, {
        initialSelectedTab: tabs[2]
      });
      cy.mount((0, _react2.jsx)(_tabbed_content.EuiTabbedContent, thirdSelectedTab));
      cy.get('div.euiTabs').should('exist');
      cy.checkAxe();
    });
    it('has zero violations with last tab open on render', function () {
      var lastSelectedTab = _objectSpread(_objectSpread({}, defaultTabProps), {}, {
        initialSelectedTab: tabs[3]
      });
      cy.mount((0, _react2.jsx)(_tabbed_content.EuiTabbedContent, lastSelectedTab));
      cy.get('div.euiTabs').should('exist');
      cy.checkAxe();
    });
    it('has zero violations with all tabs disabled except first', function () {
      var disabledTabs = tabs.map(function (tab, i) {
        if (i === 0) {
          return tab;
        }
        return _objectSpread(_objectSpread({}, tab), {}, {
          disabled: true
        });
      });
      var disabledTabProps = _objectSpread(_objectSpread({}, defaultTabProps), {}, {
        tabs: disabledTabs
      });
      cy.mount((0, _react2.jsx)(_tabbed_content.EuiTabbedContent, disabledTabProps));
      cy.get('div.euiTabs').should('exist');
      cy.checkAxe();
    });
  });
});