"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiTablePagination = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _button = require("../../button");
var _context_menu = require("../../context_menu");
var _flex = require("../../flex");
var _pagination = require("../../pagination");
var _popover = require("../../popover");
var _i18n = require("../../i18n");
var _component_defaults = require("../../provider/component_defaults");
var _table_pagination_defaults = require("./table_pagination_defaults");
var _react2 = require("@emotion/react");
var _excluded = ["activePage", "itemsPerPage", "itemsPerPageOptions", "showPerPageOptions", "onChangeItemsPerPage", "onChangePage", "pageCount"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function _iterableToArrayLimit(arr, i) { var _i = null == arr ? null : "undefined" != typeof Symbol && arr[Symbol.iterator] || arr["@@iterator"]; if (null != _i) { var _s, _e, _x, _r, _arr = [], _n = !0, _d = !1; try { if (_x = (_i = _i.call(arr)).next, 0 === i) { if (Object(_i) !== _i) return; _n = !1; } else for (; !(_n = (_s = _x.call(_i)).done) && (_arr.push(_s.value), _arr.length !== i); _n = !0); } catch (err) { _d = !0, _e = err; } finally { try { if (!_n && null != _i.return && (_r = _i.return(), Object(_r) !== _r)) return; } finally { if (_d) throw _e; } } return _arr; } }
function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }
function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }
function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
var EuiTablePagination = function EuiTablePagination(props) {
  var _usePropsWithComponen = (0, _component_defaults.usePropsWithComponentDefaults)('EuiTablePagination', props),
    activePage = _usePropsWithComponen.activePage,
    _usePropsWithComponen2 = _usePropsWithComponen.itemsPerPage,
    itemsPerPage = _usePropsWithComponen2 === void 0 ? _table_pagination_defaults.euiTablePaginationDefaults.itemsPerPage : _usePropsWithComponen2,
    _usePropsWithComponen3 = _usePropsWithComponen.itemsPerPageOptions,
    itemsPerPageOptions = _usePropsWithComponen3 === void 0 ? _table_pagination_defaults.euiTablePaginationDefaults.itemsPerPageOptions : _usePropsWithComponen3,
    _usePropsWithComponen4 = _usePropsWithComponen.showPerPageOptions,
    showPerPageOptions = _usePropsWithComponen4 === void 0 ? _table_pagination_defaults.euiTablePaginationDefaults.showPerPageOptions : _usePropsWithComponen4,
    onChangeItemsPerPage = _usePropsWithComponen.onChangeItemsPerPage,
    onChangePage = _usePropsWithComponen.onChangePage,
    pageCount = _usePropsWithComponen.pageCount,
    rest = _objectWithoutProperties(_usePropsWithComponen, _excluded);
  var _useState = (0, _react.useState)(false),
    _useState2 = _slicedToArray(_useState, 2),
    isPopoverOpen = _useState2[0],
    setIsPopoverOpen = _useState2[1];
  var togglePopover = (0, _react.useCallback)(function () {
    setIsPopoverOpen(function (isOpen) {
      return !isOpen;
    });
  }, []);
  var closePopover = (0, _react.useCallback)(function () {
    setIsPopoverOpen(false);
  }, []);
  var button = (0, _react2.jsx)(_button.EuiButtonEmpty, {
    size: "xs",
    color: "text",
    iconType: "arrowDown",
    iconSide: "right",
    "data-test-subj": "tablePaginationPopoverButton",
    onClick: togglePopover
  }, itemsPerPage === 0 ? (0, _react2.jsx)(_i18n.EuiI18n, {
    token: "euiTablePagination.allRows",
    default: "Showing all rows"
  }) : (0, _react2.jsx)(_react.default.Fragment, null, (0, _react2.jsx)(_i18n.EuiI18n, {
    token: "euiTablePagination.rowsPerPage",
    default: "Rows per page"
  }), ": ", itemsPerPage));
  var items = (0, _react.useMemo)(function () {
    return itemsPerPageOptions.map(function (itemsPerPageOption) {
      return (0, _react2.jsx)(_context_menu.EuiContextMenuItem, {
        key: itemsPerPageOption,
        icon: itemsPerPageOption === itemsPerPage ? 'check' : 'empty',
        "aria-current": itemsPerPageOption === itemsPerPage ? 'true' : undefined,
        onClick: function onClick() {
          closePopover();
          onChangeItemsPerPage === null || onChangeItemsPerPage === void 0 ? void 0 : onChangeItemsPerPage(itemsPerPageOption);
        },
        "data-test-subj": "tablePagination-".concat(itemsPerPageOption, "-rows")
      }, itemsPerPageOption === 0 ? (0, _react2.jsx)(_i18n.EuiI18n, {
        token: "euiTablePagination.rowsPerPageOptionShowAllRows",
        default: "Show all rows"
      }) : (0, _react2.jsx)(_i18n.EuiI18n, {
        token: "euiTablePagination.rowsPerPageOption",
        values: {
          rowsPerPage: itemsPerPageOption
        },
        default: "{rowsPerPage} rows"
      }));
    });
  }, [itemsPerPageOptions, itemsPerPage, onChangeItemsPerPage, closePopover]);
  var itemsPerPagePopover = (0, _react2.jsx)(_popover.EuiPopover, {
    button: button,
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    panelPaddingSize: "none",
    anchorPosition: "upRight"
  }, (0, _react2.jsx)(_context_menu.EuiContextMenuPanel, {
    items: items,
    "data-test-subj": "tablePaginationRowOptions"
  }));
  return (0, _react2.jsx)(_flex.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center",
    responsive: false,
    wrap: true,
    gutterSize: "s",
    className: "eui-xScroll"
  }, (0, _react2.jsx)(_flex.EuiFlexItem, {
    grow: false
  }, showPerPageOptions && itemsPerPagePopover), (0, _react2.jsx)(_flex.EuiFlexItem, {
    grow: false
  }, itemsPerPage > 0 && (0, _react2.jsx)(_pagination.EuiPagination, _extends({
    pageCount: pageCount,
    activePage: activePage,
    onPageClick: onChangePage
  }, rest))));
};
exports.EuiTablePagination = EuiTablePagination;
EuiTablePagination.propTypes = {
  /**
     * Option to completely hide the "Rows per page" selector.
     *
     * @default true
     */
  showPerPageOptions: _propTypes.default.bool,
  /**
     * Current selection for "Rows per page".
     * Pass `0` to display the selected "Show all" option and hide the pagination.
     *
     * @default 10
     */
  itemsPerPage: _propTypes.default.number,
  /**
     * Custom array of options for "Rows per page".
     * Pass `0` as one of the options to create a "Show all" option.
     *
     * @default [10, 25, 50]
     */
  itemsPerPageOptions: _propTypes.default.arrayOf(_propTypes.default.number.isRequired),
  /**
     * Click handler that passes back selected `pageSize` number
     */
  onChangeItemsPerPage: _propTypes.default.func,
  onChangePage: _propTypes.default.func,
  /**
     * Requires the `id` of the table being controlled
     */
  "aria-controls": _propTypes.default.string,
  "aria-label": _propTypes.default.string
};