"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiResizableCollapseButton = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../services");
var _button = require("../button");
var _screen_reader_only = require("../accessibility/screen_reader_only/screen_reader_only.styles");
var _resizable_collapse_button = require("./resizable_collapse_button.styles");
var _react2 = require("@emotion/react");
var _excluded = ["className", "externalPosition", "internalPosition", "direction", "isVisible", "isCollapsed"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null) return Array.from(iter); }
function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }
function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
var EuiResizableCollapseButton = function EuiResizableCollapseButton(_ref) {
  var className = _ref.className,
    _ref$externalPosition = _ref.externalPosition,
    externalPosition = _ref$externalPosition === void 0 ? 'before' : _ref$externalPosition,
    _ref$internalPosition = _ref.internalPosition,
    internalPosition = _ref$internalPosition === void 0 ? 'middle' : _ref$internalPosition,
    _ref$direction = _ref.direction,
    direction = _ref$direction === void 0 ? 'horizontal' : _ref$direction,
    isVisible = _ref.isVisible,
    isCollapsed = _ref.isCollapsed,
    rest = _objectWithoutProperties(_ref, _excluded);
  var isHorizontal = direction === 'horizontal';
  var showOnFocus = !isCollapsed && !isVisible;
  var screenReaderOnlyStyles = (0, _screen_reader_only.euiScreenReaderOnlyStyles)(showOnFocus).euiScreenReaderOnly;
  var euiTheme = (0, _services.useEuiTheme)();
  var styles = (0, _resizable_collapse_button.euiResizableCollapseButtonStyles)(euiTheme);
  var collapsedStyles = [styles.collapsed.collapsed, styles.collapsed[direction], styles.collapsed["".concat(direction, "Positions")][internalPosition]];
  var collapsibleStyles = [styles.collapsible.collapsible, styles.collapsible[direction][externalPosition], styles.collapsible[direction][internalPosition]];
  var cssStyles = [styles.euiResizableCollapseButton, showOnFocus && screenReaderOnlyStyles].concat(_toConsumableArray(isCollapsed ? collapsedStyles : collapsibleStyles));
  var COLLAPSED_ICON = '';
  var NOT_COLLAPSED_ICON = '';
  switch (externalPosition) {
    case 'before':
      COLLAPSED_ICON = isHorizontal ? 'menuLeft' : 'menuUp';
      NOT_COLLAPSED_ICON = isHorizontal ? 'menuRight' : 'menuDown';
      break;
    case 'after':
      COLLAPSED_ICON = isHorizontal ? 'menuRight' : 'menuDown';
      NOT_COLLAPSED_ICON = isHorizontal ? 'menuLeft' : 'menuUp';
      break;
  }
  var classes = (0, _classnames.default)('euiResizableCollapseButton', className);
  return (0, _react2.jsx)(_button.EuiButtonIcon, _extends({
    display: isCollapsed ? 'empty' : 'base',
    color: "text",
    className: classes,
    css: cssStyles
  }, rest, {
    iconType: isCollapsed ? COLLAPSED_ICON : NOT_COLLAPSED_ICON
  }));
};
exports.EuiResizableCollapseButton = EuiResizableCollapseButton;
EuiResizableCollapseButton.propTypes = {
  /**
     * Position of the toggle button.
     * Enums based on the `direction` of the EuiResizableContainer
     */
  internalPosition: _propTypes.default.oneOf(["top", "middle", "bottom", "left", "right"]),
  /**
     * Position of the toggle button.
     * Enums based on the `direction` of the EuiResizableContainer
     */
  externalPosition: _propTypes.default.oneOf(["before", "after"]),
  /**
     * Same direction derived from EuiResizableContainer
     */
  direction: _propTypes.default.oneOf(["vertical", "horizontal"]),
  isVisible: _propTypes.default.bool,
  isCollapsed: _propTypes.default.bool
};