"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiResizableButtonWithControls = exports.EuiResizableButtonControlled = exports.EuiResizableButton = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _i18n = require("../i18n");
var _services = require("../../services");
var _context = require("./context");
var _resizable_button = require("./resizable_button.styles");
var _react2 = require("@emotion/react");
var _excluded = ["isHorizontal", "alignIndicator", "className"],
  _excluded2 = ["registration", "id", "disabled", "onFocus"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function _iterableToArrayLimit(arr, i) { var _i = null == arr ? null : "undefined" != typeof Symbol && arr[Symbol.iterator] || arr["@@iterator"]; if (null != _i) { var _s, _e, _x, _r, _arr = [], _n = !0, _d = !1; try { if (_x = (_i = _i.call(arr)).next, 0 === i) { if (Object(_i) !== _i) return; _n = !1; } else for (; !(_n = (_s = _x.call(_i)).done) && (_arr.push(_s.value), _arr.length !== i); _n = !0); } catch (err) { _d = !0, _e = err; } finally { try { if (!_n && null != _i.return && (_r = _i.return(), Object(_r) !== _r)) return; } finally { if (_d) throw _e; } } return _arr; } }
function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }
function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }
function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
/**
 * A generic button for indicating/facilitating resizable content,
 * usable outside of the EuiResizableContainer context
 */
var EuiResizableButton = /*#__PURE__*/(0, _react.forwardRef)(function (_ref, ref) {
  var isHorizontal = _ref.isHorizontal,
    _ref$alignIndicator = _ref.alignIndicator,
    alignIndicator = _ref$alignIndicator === void 0 ? 'center' : _ref$alignIndicator,
    className = _ref.className,
    rest = _objectWithoutProperties(_ref, _excluded);
  var classes = (0, _classnames.default)('euiResizableButton', className);
  var euiTheme = (0, _services.useEuiTheme)();
  var styles = (0, _resizable_button.euiResizableButtonStyles)(euiTheme);
  var cssStyles = [styles.euiResizableButton, isHorizontal ? styles.horizontal : styles.vertical, styles.alignIndicator[alignIndicator]];
  return (0, _react2.jsx)(_i18n.EuiI18n, {
    tokens: ['euiResizableButton.horizontalResizerAriaLabel', 'euiResizableButton.verticalResizerAriaLabel'],
    defaults: ['Press the left or right arrow keys to adjust panels size', 'Press the up or down arrow keys to adjust panels size']
  }, function (_ref2) {
    var _ref3 = _slicedToArray(_ref2, 2),
      horizontalResizerAriaLabel = _ref3[0],
      verticalResizerAriaLabel = _ref3[1];
    return (0, _react2.jsx)("button", _extends({
      ref: ref,
      "aria-label": isHorizontal ? horizontalResizerAriaLabel : verticalResizerAriaLabel,
      className: classes,
      css: cssStyles,
      "data-test-subj": "euiResizableButton",
      type: "button"
    }, rest));
  });
});
exports.EuiResizableButton = EuiResizableButton;
EuiResizableButton.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  /**
       * Defaults to displaying a resizer for vertical (y-axis) resizing.
       * Set to `true` to display a resizer for horizontal (x-axis) resizing.
       */
  isHorizontal: _propTypes.default.bool,
  /**
       * Specify the alignment of the initial resize indicator. Defaults to `center`,
       * but consider using `start` for extremely tall content that scrolls off-screen
       */
  alignIndicator: _propTypes.default.oneOf(["center", "start", "end"]),
  /**
       * When disabled, the resizer button will be completely hidden
       */
  disabled: _propTypes.default.bool
};
EuiResizableButton.displayName = 'EuiResizableButton';

/**
 * Resizer button specific to controlled EuiResizableContainer usage
 */

var EuiResizableButtonControlled = function EuiResizableButtonControlled(_ref4) {
  var registration = _ref4.registration,
    id = _ref4.id,
    disabled = _ref4.disabled,
    _onFocus = _ref4.onFocus,
    rest = _objectWithoutProperties(_ref4, _excluded2);
  var resizerId = (0, _services.useGeneratedHtmlId)({
    prefix: 'resizable-button',
    conditionalId: id
  });
  var _useEuiResizableConta = (0, _context.useEuiResizableContainerContext)(),
    _useEuiResizableConta2 = _useEuiResizableConta.registry,
    _useEuiResizableConta3 = _useEuiResizableConta2 === void 0 ? {
      resizers: {}
    } : _useEuiResizableConta2,
    resizers = _useEuiResizableConta3.resizers;
  var isDisabled = (0, _react.useMemo)(function () {
    var _resizers$resizerId;
    return disabled || ((_resizers$resizerId = resizers[resizerId]) === null || _resizers$resizerId === void 0 ? void 0 : _resizers$resizerId.isDisabled);
  }, [resizers, resizerId, disabled]);
  var previousRef = (0, _react.useRef)();
  var onRef = (0, _react.useCallback)(function (ref) {
    if (!registration) return;
    if (ref) {
      previousRef.current = ref;
      registration.register({
        id: resizerId,
        ref: ref,
        isFocused: false,
        isDisabled: disabled || false
      });
    } else {
      if (previousRef.current != null) {
        registration.deregister(resizerId);
        previousRef.current = undefined;
      }
    }
  }, [registration, resizerId, disabled]);
  return (0, _react2.jsx)(EuiResizableButton, _extends({
    id: resizerId,
    ref: onRef,
    disabled: isDisabled,
    onClick: function onClick(e) {
      return e.currentTarget.focus();
    },
    onFocus: function onFocus() {
      return _onFocus === null || _onFocus === void 0 ? void 0 : _onFocus(resizerId);
    }
  }, rest));
};
exports.EuiResizableButtonControlled = EuiResizableButtonControlled;
var euiResizableButtonWithControls = function euiResizableButtonWithControls(controls) {
  return function (props) {
    return (0, _react2.jsx)(EuiResizableButtonControlled, _extends({}, controls, props));
  };
};
exports.euiResizableButtonWithControls = euiResizableButtonWithControls;