"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usePropsWithComponentDefaults = exports.useComponentDefaults = exports.EuiComponentDefaultsProvider = exports.EuiComponentDefaultsContext = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react2 = require("@emotion/react");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); } /*
                                                                                                                                                                                                                                                                                                                                                                                               * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                                                               * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                               * 2.0 and the Server Side Public License, v 1; you may not use this file except
                                                                                                                                                                                                                                                                                                                                                                                               * in compliance with, at your election, the Elastic License 2.0 or the Server
                                                                                                                                                                                                                                                                                                                                                                                               * Side Public License, v 1.
                                                                                                                                                                                                                                                                                                                                                                                               */
// Declaring as a static const for reference integrity/reducing rerenders
var emptyDefaults = {};

/*
 * Context
 */
var EuiComponentDefaultsContext = /*#__PURE__*/(0, _react.createContext)(emptyDefaults);

/*
 * Component
 */
exports.EuiComponentDefaultsContext = EuiComponentDefaultsContext;
var EuiComponentDefaultsProvider = function EuiComponentDefaultsProvider(_ref) {
  var _ref$componentDefault = _ref.componentDefaults,
    componentDefaults = _ref$componentDefault === void 0 ? emptyDefaults : _ref$componentDefault,
    children = _ref.children;
  return (0, _react2.jsx)(EuiComponentDefaultsContext.Provider, {
    value: componentDefaults
  }, children);
};

/*
 * Hooks
 */
exports.EuiComponentDefaultsProvider = EuiComponentDefaultsProvider;
EuiComponentDefaultsProvider.propTypes = {
  componentDefaults: _propTypes.default.shape({
    /**
       * Provide a global configuration for EuiPortal's default insertion position.
       */
    EuiPortal: _propTypes.default.any,
    /**
       * Provide a global configuration for EuiFocusTrap's `gapMode` and `crossFrame` props
       */
    EuiFocusTrap: _propTypes.default.any,
    /**
       * Provide global settings for EuiTablePagination's props that affect page size
       * / the rows per page selection.
       *
       * These defaults will be inherited all table and grid components that utilize EuiTablePagination.
       */
    EuiTablePagination: _propTypes.default.any
  })
};
var useComponentDefaults = function useComponentDefaults() {
  return (0, _react.useContext)(EuiComponentDefaultsContext);
};

// Merge individual component props with component defaults
exports.useComponentDefaults = useComponentDefaults;
var usePropsWithComponentDefaults = function usePropsWithComponentDefaults(componentName, props) {
  var _context$componentNam;
  var context = (0, _react.useContext)(EuiComponentDefaultsContext);
  var componentDefaults = (_context$componentNam = context[componentName]) !== null && _context$componentNam !== void 0 ? _context$componentNam : emptyDefaults;
  return (0, _react.useMemo)(function () {
    return _objectSpread(_objectSpread({}, componentDefaults), props);
  }, [componentDefaults, props]);
};
exports.usePropsWithComponentDefaults = usePropsWithComponentDefaults;