"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiRangeTooltip = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _services = require("../../../services");
var _global_styling = require("../../../global_styling");
var _range_tooltip = require("./range_tooltip.styles");
var _react2 = require("@emotion/react");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var EuiRangeTooltip = function EuiRangeTooltip(_ref) {
  var value = _ref.value,
    valueAppend = _ref.valueAppend,
    valuePrepend = _ref.valuePrepend,
    max = _ref.max,
    min = _ref.min,
    name = _ref.name,
    showTicks = _ref.showTicks;
  // Calculate the left position based on value
  var valuePosition = (0, _react.useMemo)(function () {
    var val = 0;
    if (typeof value === 'number') {
      val = value;
    } else if (typeof value === 'string') {
      val = parseFloat(value);
    }
    var decimal = (val - min) / (max - min);
    // Must be between 0-100%
    var valuePosition = decimal <= 1 ? decimal : 1;
    return valuePosition >= 0 ? valuePosition : 0;
  }, [value, min, max]);

  // Change left/right position based on value (half way point)
  var valuePositionSide = (0, _react.useMemo)(function () {
    return valuePosition > 0.5 ? 'left' : 'right';
  }, [valuePosition]);
  var valuePositionStyle = (0, _react.useMemo)(function () {
    if (valuePositionSide === 'left') {
      return (0, _global_styling.logicalStyles)({
        right: "".concat((1 - valuePosition) * 100, "%")
      });
    } else if (valuePositionSide === 'right') {
      return (0, _global_styling.logicalStyles)({
        left: "".concat(valuePosition * 100, "%")
      });
    }
  }, [valuePosition, valuePositionSide]);
  var euiTheme = (0, _services.useEuiTheme)();
  var styles = (0, _range_tooltip.euiRangeTooltipStyles)(euiTheme);
  var cssStyles = [styles.euiRangeTooltip];
  var valueStyles = (0, _range_tooltip.euiRangeTooltipValueStyles)(euiTheme);
  var cssValueStyles = [valueStyles.euiRangeTooltip__value, valueStyles[valuePositionSide], showTicks && valueStyles.hasTicks];
  return (0, _react2.jsx)("div", {
    className: "euiRangeTooltip",
    css: cssStyles
  }, (0, _react2.jsx)("output", {
    className: "euiRangeTooltip__value",
    css: cssValueStyles,
    htmlFor: name,
    style: valuePositionStyle
  }, valuePrepend, value, valueAppend));
};
exports.EuiRangeTooltip = EuiRangeTooltip;
EuiRangeTooltip.propTypes = {
  name: _propTypes.default.string
};