"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiRangeInput = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _services = require("../../../services");
var _global_styling = require("../../../global_styling");
var _form = require("../form.styles");
var _field_number = require("../field_number");
var _range_input = require("./range_input.styles");
var _react2 = require("@emotion/react");
var _excluded = ["min", "max", "step", "value", "inputRef", "isInvalid", "disabled", "compressed", "onChange", "name", "side", "fullWidth", "autoSize"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function _iterableToArrayLimit(arr, i) { var _i = null == arr ? null : "undefined" != typeof Symbol && arr[Symbol.iterator] || arr["@@iterator"]; if (null != _i) { var _s, _e, _x, _r, _arr = [], _n = !0, _d = !1; try { if (_x = (_i = _i.call(arr)).next, 0 === i) { if (Object(_i) !== _i) return; _n = !1; } else for (; !(_n = (_s = _x.call(_i)).done) && (_arr.push(_s.value), _arr.length !== i); _n = !0); } catch (err) { _d = !0, _e = err; } finally { try { if (!_n && null != _i.return && (_r = _i.return(), Object(_r) !== _r)) return; } finally { if (_d) throw _e; } } return _arr; } }
function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }
function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }
function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
var EuiRangeInput = function EuiRangeInput(_ref) {
  var min = _ref.min,
    max = _ref.max,
    step = _ref.step,
    value = _ref.value,
    inputRef = _ref.inputRef,
    isInvalid = _ref.isInvalid,
    disabled = _ref.disabled,
    compressed = _ref.compressed,
    onChange = _ref.onChange,
    name = _ref.name,
    _ref$side = _ref.side,
    side = _ref$side === void 0 ? 'max' : _ref$side,
    fullWidth = _ref.fullWidth,
    _ref$autoSize = _ref.autoSize,
    autoSize = _ref$autoSize === void 0 ? true : _ref$autoSize,
    rest = _objectWithoutProperties(_ref, _excluded);
  var euiTheme = (0, _services.useEuiTheme)();
  var styles = (0, _range_input.euiRangeInputStyles)(euiTheme);
  var cssStyles = [styles.euiRangeInput];

  // Determine whether an invalid icon is showing, which can come from
  // the underlying EuiFieldNumber's native :invalid state
  var _useState = (0, _react.useState)(isInvalid),
    _useState2 = _slicedToArray(_useState, 2),
    hasInvalidIcon = _useState2[0],
    setHasInvalidIcon = _useState2[1];
  var validityRef = (0, _react.useRef)(null);
  var setRefs = (0, _services.useCombinedRefs)([validityRef, inputRef]);
  (0, _react.useEffect)(function () {
    var _validityRef$current;
    var isNativelyInvalid = !((_validityRef$current = validityRef.current) !== null && _validityRef$current !== void 0 && _validityRef$current.validity.valid);
    setHasInvalidIcon(isNativelyInvalid || isInvalid);
  }, [value, isInvalid]);

  // Calculate the auto size width of the input
  var widthStyle = (0, _react.useMemo)(function () {
    if (!autoSize) return undefined;

    // Calculate the number of characters to show (dynamic based on user input)
    // Uses the min/max char length as a max, then add an extra UX buffer of 1
    var maxChars = Math.max(String(min).length, String(max).length) + 1;
    var inputCharWidth = Math.min(String(value).length, maxChars);

    // Calculate the form padding based on `compressed` state
    var _euiFormVariables = (0, _form.euiFormVariables)(euiTheme),
      controlPadding = _euiFormVariables.controlPadding,
      controlCompressedPadding = _euiFormVariables.controlCompressedPadding;
    var inputPadding = compressed ? controlCompressedPadding : controlPadding;

    // Calculate the invalid icon (if being displayed), also based on `compressed` state
    var invalidIconWidth = hasInvalidIcon ? euiTheme.euiTheme.base * (compressed ? 1.125 : 1.375) // TODO: DRY this out once EuiFormControlLayoutIcons is converted to Emotion
    : 0;

    // Guesstimate a width for the stepper. Note that it's a little wider in FF than it is in Chrome
    var stepperWidth = 2;
    return (0, _global_styling.logicalStyles)({
      width: "calc(".concat(inputPadding, " + ").concat(inputCharWidth, "ch + ").concat(stepperWidth, "em + ").concat(invalidIconWidth, "px)")
    });
  }, [autoSize, euiTheme, compressed, hasInvalidIcon, min, max, value]);
  return (0, _react2.jsx)(_field_number.EuiFieldNumber, _extends({
    name: name,
    className: "euiRangeInput euiRangeInput--".concat(side),
    css: cssStyles,
    min: Number(min),
    max: Number(max),
    step: step,
    value: value === '' ? '' : Number(value),
    inputRef: setRefs,
    isInvalid: isInvalid,
    disabled: disabled,
    compressed: compressed,
    onChange: onChange,
    style: widthStyle,
    fullWidth: fullWidth
  }, rest));
};
exports.EuiRangeInput = EuiRangeInput;
EuiRangeInput.propTypes = {
  autoSize: _propTypes.default.bool,
  /**
     * @default 'max'
     */
  side: _propTypes.default.oneOf(["min", "max"])
};