"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiRangeDraggableStyles = exports.euiRangeDraggableInnerStyles = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../../global_styling");
var _range = require("./range.styles");
function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; } /*
                                                                                                                                                                                                                                                                                           * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                           * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                           * 2.0 and the Server Side Public License, v 1; you may not use this file except
                                                                                                                                                                                                                                                                                           * in compliance with, at your election, the Elastic License 2.0 or the Server
                                                                                                                                                                                                                                                                                           * Side Public License, v 1.
                                                                                                                                                                                                                                                                                           */
var _ref2 = process.env.NODE_ENV === "production" ? {
  name: "bpru7n-hasTicks",
  styles: "inset-block-start:0;label:hasTicks;"
} : {
  name: "bpru7n-hasTicks",
  styles: "inset-block-start:0;label:hasTicks;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var euiRangeDraggableStyles = function euiRangeDraggableStyles(euiThemeContext) {
  var range = (0, _range.euiRangeVariables)(euiThemeContext);
  return {
    euiRangeDraggable: /*#__PURE__*/(0, _react.css)("block-size:", (0, _global_styling.mathWithUnits)(range.height, function (x) {
      return x / 2;
    }), ";position:absolute;inset-block-start:", (0, _global_styling.mathWithUnits)(range.height, function (x) {
      return x / 4;
    }), ";pointer-events:none;z-index:", range.thumbZIndex, ";&:focus{outline:none;~.euiRangeThumb{", (0, _range.euiRangeThumbFocus)(euiThemeContext), ";}};label:euiRangeDraggable;"),
    hasTicks: _ref2,
    disabled: /*#__PURE__*/(0, _react.css)(";label:disabled;")
  };
};
exports.euiRangeDraggableStyles = euiRangeDraggableStyles;
var _ref = process.env.NODE_ENV === "production" ? {
  name: "ndov1k-enabled",
  styles: "cursor:grab;pointer-events:all;&:active{cursor:grabbing;};label:enabled;"
} : {
  name: "ndov1k-enabled",
  styles: "cursor:grab;pointer-events:all;&:active{cursor:grabbing;};label:enabled;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var euiRangeDraggableInnerStyles = function euiRangeDraggableInnerStyles(euiThemeContext) {
  var range = (0, _range.euiRangeVariables)(euiThemeContext);
  return {
    euiRangeDraggable__inner: /*#__PURE__*/(0, _react.css)("position:absolute;inset-inline:", range.thumbWidth, ";inset-block:0;;label:euiRangeDraggable__inner;"),
    enabled: _ref,
    disabled: /*#__PURE__*/(0, _react.css)(";label:disabled;")
  };
};
exports.euiRangeDraggableInnerStyles = euiRangeDraggableInnerStyles;