"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiRangeVariables = exports.euiRangeTrackPerBrowser = exports.euiRangeThumbStyle = exports.euiRangeThumbPerBrowser = exports.euiRangeThumbFocusBoxShadow = exports.euiRangeThumbFocus = exports.euiRangeThumbBoxShadow = exports.euiRangeThumbBorder = exports.euiRangeStyles = void 0;
var _react = require("@emotion/react");
var _services = require("../../../services");
var _global_styling = require("../../../global_styling");
var _form = require("../form.styles");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var euiRangeVariables = function euiRangeVariables(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var trackHeight = '6px';
  var thumbHeight = euiTheme.size.base;
  var thumbWidth = euiTheme.size.base;
  var form = (0, _form.euiFormVariables)(euiThemeContext);
  return {
    trackColor: euiTheme.colors.lightShade,
    highlightColor: euiTheme.colors.darkShade,
    focusColor: euiTheme.colors.primary,
    thumbHeight: thumbHeight,
    thumbWidth: thumbWidth,
    thumbBorderWidth: euiTheme.border.width.thick,
    thumbBorderColor: euiTheme.colors.emptyShade,
    thumbBackgroundColor: euiTheme.colors.darkShade,
    // same as highlightColor

    trackWidth: '100%',
    trackHeight: trackHeight,
    trackBorderWidth: '0px',
    trackBorderColor: euiTheme.colors.lightShade,
    // same as trackColor
    trackBorderRadius: euiTheme.border.radius.medium,
    tickHeight: trackHeight,
    tickWidth: euiTheme.size.xs,
    disabledOpacity: 0.5,
    highlightHeight: trackHeight,
    height: form.controlHeight,
    compressedHeight: form.controlCompressedHeight,
    // position of the track and highlight relative to the parent container
    trackTopPositionWithTicks: (0, _global_styling.mathWithUnits)([thumbHeight, trackHeight], function (x, y) {
      return (x - y) / 2;
    }),
    trackBottomPositionWithTicks: (0, _global_styling.mathWithUnits)([thumbHeight, trackHeight], function (x, y) {
      return x - (x - y) / 2;
    }),
    trackTopPositionWithoutTicks: "calc(50% - (".concat(trackHeight, " / 2))"),
    // Z-indexes
    levelsZIndex: 1,
    highlightZIndex: 2,
    thumbZIndex: 3
  };
};
exports.euiRangeVariables = euiRangeVariables;
var euiRangeTrackPerBrowser = function euiRangeTrackPerBrowser(content) {
  return "\n    &::-webkit-slider-runnable-track { ".concat(content, "; }\n    &::-moz-range-track { ").concat(content, "; }\n    &::-ms-fill-lower {").concat(content, "; }\n    &::-ms-fill-upper { ").concat(content, "; }\n  ");
};
exports.euiRangeTrackPerBrowser = euiRangeTrackPerBrowser;
var euiRangeThumbBorder = function euiRangeThumbBorder(euiThemeContext) {
  var range = euiRangeVariables(euiThemeContext);
  return "\n    border: ".concat(range.thumbBorderWidth, " solid ").concat(range.thumbBorderColor, ";\n  ");
};
exports.euiRangeThumbBorder = euiRangeThumbBorder;
var euiRangeThumbBoxShadow = function euiRangeThumbBoxShadow(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var shadowColor = "rgba(".concat((0, _services.hexToRgb)(euiTheme.colors.shadow), ", .2)");
  var range = euiRangeVariables(euiThemeContext);
  var borderWidth = range.thumbBorderWidth;
  var halfBorderWidth = (0, _global_styling.mathWithUnits)(borderWidth, function (x) {
    return x / 2;
  });
  var largeBorderWidth = (0, _global_styling.mathWithUnits)(borderWidth, function (x) {
    return x * 2.5;
  });
  return "\n    box-shadow:\n      0 0 0 ".concat(halfBorderWidth, " ").concat(range.thumbBorderColor, ",\n      0 ").concat(borderWidth, " ").concat(borderWidth, " -").concat(halfBorderWidth, " ").concat(shadowColor, ",\n      0 ").concat(halfBorderWidth, " ").concat(largeBorderWidth, " -").concat(borderWidth, " ").concat(shadowColor, ";\n  ");
};
exports.euiRangeThumbBoxShadow = euiRangeThumbBoxShadow;
var euiRangeThumbFocusBoxShadow = function euiRangeThumbFocusBoxShadow(euiThemeContext) {
  var range = euiRangeVariables(euiThemeContext);
  return "\n    box-shadow: 0 0 0 ".concat(range.thumbBorderWidth, " ").concat(range.focusColor, ";\n  ");
};
exports.euiRangeThumbFocusBoxShadow = euiRangeThumbFocusBoxShadow;
var euiRangeThumbStyle = function euiRangeThumbStyle(euiThemeContext) {
  var range = euiRangeVariables(euiThemeContext);
  return "\n    ".concat(euiRangeThumbBoxShadow(euiThemeContext), ";\n    ").concat(euiRangeThumbBorder(euiThemeContext), ";\n    cursor: pointer;\n    background-color: ").concat(range.thumbBackgroundColor, ";\n    padding: 0;\n    block-size: ").concat(range.thumbHeight, ";\n    inline-size: ").concat(range.thumbWidth, ";\n    box-sizing: border-box;  // required for firefox or the border makes the width and height to increase\n  ");
};
exports.euiRangeThumbStyle = euiRangeThumbStyle;
var euiRangeThumbPerBrowser = function euiRangeThumbPerBrowser(content) {
  return "\n    &::-webkit-slider-thumb { ".concat(content, "; }\n    &::-moz-range-thumb  { ").concat(content, "; }\n    &::-ms-thumb {").concat(content, "; }\n  ");
};
exports.euiRangeThumbPerBrowser = euiRangeThumbPerBrowser;
var euiRangeThumbFocus = function euiRangeThumbFocus(euiThemeContext, color) {
  var range = euiRangeVariables(euiThemeContext);
  return "\n   ".concat(euiRangeThumbBorder(euiThemeContext), ";\n   ").concat(euiRangeThumbFocusBoxShadow(euiThemeContext), ";\n   background-color: ").concat(color || range.focusColor, ";\n  ");
};
exports.euiRangeThumbFocus = euiRangeThumbFocus;
var euiRangeStyles = function euiRangeStyles(_ref) {
  var euiTheme = _ref.euiTheme;
  return {
    // Base
    euiRange: /*#__PURE__*/(0, _react.css)(";label:euiRange;"),
    hasInput: /*#__PURE__*/(0, _react.css)(";label:hasInput;"),
    euiRange__horizontalSpacer: /*#__PURE__*/(0, _react.css)("inline-size:", euiTheme.size.base, ";;label:euiRange__horizontalSpacer;"),
    euiRange__slimHorizontalSpacer: /*#__PURE__*/(0, _react.css)("inline-size:", euiTheme.size.s, ";;label:euiRange__slimHorizontalSpacer;")
  };
};
exports.euiRangeStyles = euiRangeStyles;