"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LAYOUTS = exports.GUTTER_SIZES = exports.EuiFacetGroup = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../services");
var _facet_group = require("./facet_group.styles");
var _react2 = require("@emotion/react");
var _excluded = ["children", "className", "layout", "gutterSize"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }
function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
var LAYOUTS = ['vertical', 'horizontal'];
exports.LAYOUTS = LAYOUTS;
var GUTTER_SIZES = ['none', 's', 'm', 'l'];
exports.GUTTER_SIZES = GUTTER_SIZES;
var EuiFacetGroup = function EuiFacetGroup(_ref) {
  var children = _ref.children,
    className = _ref.className,
    _ref$layout = _ref.layout,
    layout = _ref$layout === void 0 ? 'vertical' : _ref$layout,
    _ref$gutterSize = _ref.gutterSize,
    gutterSize = _ref$gutterSize === void 0 ? 'm' : _ref$gutterSize,
    rest = _objectWithoutProperties(_ref, _excluded);
  var theme = (0, _services.useEuiTheme)();
  var styles = (0, _facet_group.euiFacetGroupStyles)(theme, layout);
  var cssStyles = [styles.euiFacetGroup, styles[gutterSize], styles[layout]];
  var classes = (0, _classnames.default)('euiFacetGroup', className);
  return (0, _react2.jsx)("div", _extends({
    className: classes,
    css: cssStyles
  }, rest), children);
};
exports.EuiFacetGroup = EuiFacetGroup;
EuiFacetGroup.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  /**
       * Vertically in a column, or horizontally in one wrapping line
       */
  layout: _propTypes.default.any,
  /**
       * Distance between facet buttons.
       * Horizontal layout always adds more distance horizontally between buttons.
       */
  gutterSize: _propTypes.default.any
};