"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiCollapsibleNavGroup = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../../services");
var _context = require("../context");
var _collapsible_nav_item = require("../collapsible_nav_item/collapsible_nav_item");
var _collapsed_nav_popover = require("../collapsible_nav_item/collapsed/collapsed_nav_popover");
var _collapsible_nav_group = require("./collapsible_nav_group.styles");
var _react2 = require("@emotion/react");
var _excluded = ["items", "className", "wrapperProps"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }
function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
/**
 * This component should only ever be used as a **top-level component**, and not as a sub-item.
 * It also should **not** be used in the nav footer.
 */
var EuiCollapsibleNavGroup = function EuiCollapsibleNavGroup(_ref) {
  var items = _ref.items,
    className = _ref.className,
    wrapperProps = _ref.wrapperProps,
    props = _objectWithoutProperties(_ref, _excluded);
  var _useContext = (0, _react.useContext)(_context.EuiCollapsibleNavContext),
    isCollapsed = _useContext.isCollapsed,
    isPush = _useContext.isPush;
  var classes = (0, _classnames.default)('euiCollapsibleNavGroup', className, wrapperProps === null || wrapperProps === void 0 ? void 0 : wrapperProps.className);
  var euiTheme = (0, _services.useEuiTheme)();
  var styles = (0, _collapsible_nav_group.euiCollapsibleNavGroupStyles)(euiTheme);
  var cssStyles = [styles.euiCollapsibleNavGroup, isPush && isCollapsed ? styles.euiCollapsibleNavGroup__title : styles.isWrapper, wrapperProps === null || wrapperProps === void 0 ? void 0 : wrapperProps.css];
  return (0, _react2.jsx)("div", _extends({}, wrapperProps, {
    className: classes,
    css: cssStyles
  }), isCollapsed && isPush ? (0, _react2.jsx)(_collapsed_nav_popover.EuiCollapsedNavPopover, _extends({
    className: classes,
    items: items
  }, props)) : (0, _react2.jsx)(_react.default.Fragment, null, (0, _react2.jsx)(_collapsible_nav_item.EuiCollapsibleNavItem, _extends({}, props, {
    css: styles.euiCollapsibleNavGroup__title
  })), (0, _react2.jsx)(_collapsible_nav_item.EuiCollapsibleNavSubItems, {
    items: items,
    isGroup: true
  })));
};
exports.EuiCollapsibleNavGroup = EuiCollapsibleNavGroup;
EuiCollapsibleNavGroup.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  /**
       * Highlights whether an item is currently selected, e.g.
       * if the user is on the same page as the nav link
       */
  isSelected: _propTypes.default.bool,
  /**
       * Optional props to pass to the wrapping div
       */
  wrapperProps: _propTypes.default.shape({
    className: _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "data-test-subj": _propTypes.default.string,
    css: _propTypes.default.any
  })
};