"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiCollapsibleNavFooter = exports.EuiCollapsibleNavBody = void 0;
var _react = _interopRequireWildcard(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../services");
var _flyout = require("../flyout");
var _context = require("./context");
var _collapsible_nav_body_footer = require("./collapsible_nav_body_footer.styles");
var _react2 = require("@emotion/react");
var _excluded = ["className"],
  _excluded2 = ["className"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
/**
 * These components are incredibly light wrappers around `EuiFlyoutBody`
 * and `EuiFlyoutFooter` with collapsible nav-specific styling/considerations.
 *
 * Note: They are not intended to be used standalone outside of EuiCollapsibleNav
 */
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }
function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
var EuiCollapsibleNavBody = function EuiCollapsibleNavBody(_ref) {
  var className = _ref.className,
    props = _objectWithoutProperties(_ref, _excluded);
  var classes = (0, _classnames.default)('euiCollapsibleNav__body', className);
  var _useContext = (0, _react.useContext)(_context.EuiCollapsibleNavContext),
    isCollapsed = _useContext.isCollapsed,
    isPush = _useContext.isPush;
  var cssStyles = [_collapsible_nav_body_footer.euiCollapsibleNavBodyStyles.euiCollapsibleNav__body, isCollapsed && isPush && _collapsible_nav_body_footer.euiCollapsibleNavBodyStyles.isPushCollapsed];
  return (0, _react2.jsx)(_flyout.EuiFlyoutBody, _extends({
    className: classes,
    css: cssStyles
    // Since this is a nav, we can almost guarantee there will be clickable
    // children/links that will enable scrolling. As such, we're optimistically
    // removing the extra tab stop
    ,
    scrollableTabIndex: -1
  }, props));
};
exports.EuiCollapsibleNavBody = EuiCollapsibleNavBody;
var EuiCollapsibleNavFooter = function EuiCollapsibleNavFooter(_ref2) {
  var className = _ref2.className,
    props = _objectWithoutProperties(_ref2, _excluded2);
  var classes = (0, _classnames.default)('euiCollapsibleNav__footer', className);
  var _useContext2 = (0, _react.useContext)(_context.EuiCollapsibleNavContext),
    isCollapsed = _useContext2.isCollapsed,
    isPush = _useContext2.isPush;
  var euiTheme = (0, _services.useEuiTheme)();
  var styles = (0, _collapsible_nav_body_footer.euiCollapsibleNavFooterStyles)(euiTheme);
  var cssStyles = [styles.euiCollapsibleNav__footer, isCollapsed && isPush && styles.isPushCollapsed];
  return (0, _react2.jsx)(_flyout.EuiFlyoutFooter, _extends({
    className: classes,
    css: cssStyles
  }, props));
};
exports.EuiCollapsibleNavFooter = EuiCollapsibleNavFooter;